/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sys;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.epics.pvmanager.sys.SystemChannelHandler;
import org.epics.vtype.Alarm;
import org.epics.vtype.AlarmSeverity;
import org.epics.vtype.Time;
import org.epics.vtype.ValueFactory;

class QualifiedHostnameChannelHandler
extends SystemChannelHandler {
    private String previousValue = null;

    public QualifiedHostnameChannelHandler(String channelName) {
        super(channelName);
    }

    @Override
    protected Object createValue() {
        Alarm alarm;
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
            alarm = ValueFactory.alarmNone();
        }
        catch (UnknownHostException ex) {
            hostname = "Unknown host";
            alarm = ValueFactory.newAlarm((AlarmSeverity)AlarmSeverity.INVALID, (String)"Undefined");
        }
        if (!Objects.equals(hostname, this.previousValue)) {
            this.previousValue = hostname;
            return ValueFactory.newVString((String)hostname, (Alarm)alarm, (Time)ValueFactory.timeNow());
        }
        return null;
    }
}

