/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sys;

import java.util.Objects;
import org.epics.pvmanager.sys.SystemChannelHandler;
import org.epics.vtype.Alarm;
import org.epics.vtype.Time;
import org.epics.vtype.ValueFactory;

class UserChannelHandler
extends SystemChannelHandler {
    private final String propertyName;
    private String previousValue = null;

    public UserChannelHandler(String channelName) {
        super(channelName);
        this.propertyName = "user.name";
    }

    @Override
    protected Object createValue() {
        String value = System.getProperty(this.propertyName);
        if (value == null) {
            value = "";
        }
        if (!Objects.equals(value, this.previousValue)) {
            this.previousValue = value;
            return ValueFactory.newVString((String)value, (Alarm)ValueFactory.alarmNone(), (Time)ValueFactory.timeNow());
        }
        return null;
    }
}

