/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager;

import org.epics.pvmanager.ChannelReadRecipe;
import org.epics.pvmanager.PVReaderDirector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.ReadRecipe;
import org.epics.pvmanager.ValueCache;
import org.epics.pvmanager.expression.DesiredRateExpression;

public class ReadExpressionTester {
    private DesiredRateExpression<?> expression;
    private ReadRecipe readRecipe;
    private PVReaderDirector<?> pvReaderDirector = new PVReaderDirector(null, null, null, null, null, null);

    public ReadExpressionTester(DesiredRateExpression<?> expression) {
        this.expression = expression;
        this.pvReaderDirector.connectExpression(expression);
    }

    public ReadRecipe getCurrentReadRecipe() {
        return this.pvReaderDirector.getCurrentReadRecipe();
    }

    public void writeValue(String name, Object value) {
        boolean written = false;
        for (ChannelReadRecipe channelRecipe : this.getCurrentReadRecipe().getChannelReadRecipes()) {
            if (!channelRecipe.getChannelName().equals(name)) continue;
            ValueCache cache = channelRecipe.getReadSubscription().getValueCache();
            cache.writeValue(value);
            written = true;
        }
        if (!written) {
            throw new IllegalStateException("Can't find recipe for channel '" + name + "'");
        }
    }

    public ChannelReadRecipe recipeFor(String channelName) {
        for (ChannelReadRecipe channelRecipe : this.getCurrentReadRecipe().getChannelReadRecipes()) {
            if (!channelRecipe.getChannelName().equals(channelName)) continue;
            return channelRecipe;
        }
        return null;
    }

    public ReadRecipe getReadRecipe() {
        return this.getCurrentReadRecipe();
    }

    public ReadFunction<?> getFunction() {
        return this.expression.getFunction();
    }

    public DesiredRateExpression<?> getExpression() {
        return this.expression;
    }

    public Object getValue() {
        return this.expression.getFunction().readValue();
    }
}

