/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.util.time.TimeDuration;

public class CountDownPVReaderListener
implements PVReaderListener<Object> {
    private volatile CountDownLatch latch;
    private volatile PVReaderEvent<Object> event;

    public CountDownPVReaderListener(int count) {
        this.latch = new CountDownLatch(count);
    }

    public void pvChanged(PVReaderEvent<Object> event) {
        this.event = event;
        this.latch.countDown();
    }

    public void resetCount(int count) {
        this.latch = new CountDownLatch(count);
    }

    public int getCount() {
        return (int)this.latch.getCount();
    }

    public boolean await(TimeDuration duration) throws InterruptedException {
        return this.latch.await(duration.toNanosLong(), TimeUnit.NANOSECONDS);
    }

    public PVReaderEvent<Object> getEvent() {
        return this.event;
    }
}

