/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.test;

import java.util.concurrent.Callable;
import org.epics.pvmanager.PVReader;
import org.epics.util.time.TimeDuration;
import org.epics.util.time.TimeInterval;
import org.epics.util.time.Timestamp;

public class ThreadTestingUtil {
    public static <T> T waitFor(Callable<T> task, TimeDuration timeout) throws Exception {
        TimeInterval runInterval = timeout.after(Timestamp.now());
        while (runInterval.contains(Timestamp.now())) {
            T value = task.call();
            if (value != null) {
                return value;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    public static TimeDuration waitForValue(PVReader<?> pvReader, TimeDuration timeout) {
        TimeInterval runInterval = timeout.after(Timestamp.now());
        while (runInterval.contains(Timestamp.now())) {
            if (pvReader.getValue() != null) {
                return runInterval.getStart().durationBetween(Timestamp.now());
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }
}

