/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.test;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.epics.pvmanager.ChannelHandler;
import org.epics.pvmanager.ChannelReadRecipe;
import org.epics.pvmanager.ChannelWriteRecipe;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.ExceptionHandler;
import org.epics.pvmanager.ReadRecipe;
import org.epics.pvmanager.WriteRecipe;

public class MockDataSource
extends DataSource {
    private final List<ChannelReadRecipe> connectedReadRecipes = new CopyOnWriteArrayList<ChannelReadRecipe>();
    private final List<ChannelWriteRecipe> connectedWriteRecipes = new CopyOnWriteArrayList<ChannelWriteRecipe>();
    private volatile ReadRecipe readRecipe;
    private volatile WriteRecipe writeRecipe;
    private volatile WriteRecipe writeRecipeForWrite;

    public MockDataSource() {
        super(true);
    }

    protected ChannelHandler createChannel(String channelName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void connectRead(ReadRecipe recipe) {
        this.readRecipe = recipe;
        this.connectedReadRecipes.addAll(recipe.getChannelReadRecipes());
    }

    public void disconnectRead(ReadRecipe recipe) {
        this.readRecipe = recipe;
        this.connectedReadRecipes.removeAll(recipe.getChannelReadRecipes());
    }

    public void connectWrite(WriteRecipe writeRecipe) {
        this.writeRecipe = writeRecipe;
        this.connectedWriteRecipes.addAll(writeRecipe.getChannelWriteRecipes());
    }

    public void disconnectWrite(WriteRecipe writeRecipe) {
        this.writeRecipe = writeRecipe;
        this.connectedWriteRecipes.removeAll(writeRecipe.getChannelWriteRecipes());
    }

    public void write(WriteRecipe writeRecipe, Runnable callback, ExceptionHandler exceptionHandler) {
        this.writeRecipeForWrite = writeRecipe;
    }

    public ReadRecipe getReadRecipe() {
        return this.readRecipe;
    }

    public WriteRecipe getWriteRecipe() {
        return this.writeRecipe;
    }

    public WriteRecipe getWriteRecipeForWrite() {
        return this.writeRecipeForWrite;
    }

    public List<ChannelReadRecipe> getConnectedReadRecipes() {
        return this.connectedReadRecipes;
    }

    public List<ChannelWriteRecipe> getConnectedWriteRecipes() {
        return this.connectedWriteRecipes;
    }
}

