/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import okhttp3.OkHttpClient;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BlockchainContextBuilder;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ErgoNodeFacade;
import org.ergoplatform.appkit.impl.ErgoWalletImpl;
import org.ergoplatform.restapi.client.ApiClient;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.NodeInfo;
import org.ergoplatform.restapi.client.WalletBox;
import retrofit2.Retrofit;

public class BlockchainContextBuilderImpl
implements BlockchainContextBuilder {
    private final ApiClient _client;
    private final NetworkType _networkType;
    private OkHttpClient _ok;
    private Retrofit _retrofit;
    private NodeInfo _nodeInfo;
    private List<BlockHeader> _headers;

    public BlockchainContextBuilderImpl(ApiClient apiClient, NetworkType networkType) {
        this._client = apiClient;
        this._networkType = networkType;
    }

    @Override
    public BlockchainContext build() throws ErgoClientException {
        this._ok = this._client.getOkBuilder().build();
        this._retrofit = this._client.getAdapterBuilder().client(this._ok).build();
        this._nodeInfo = ErgoNodeFacade.getNodeInfo(this._retrofit);
        this._headers = ErgoNodeFacade.getLastHeaders(this._retrofit, BigDecimal.valueOf(10L));
        Collections.reverse(this._headers);
        List<WalletBox> list = ErgoNodeFacade.getWalletUnspentBoxes(this._retrofit, 0, 0);
        ErgoWalletImpl ergoWalletImpl = new ErgoWalletImpl(list);
        return new BlockchainContextImpl(this._client, this._retrofit, this._networkType, this._nodeInfo, this._headers, ergoWalletImpl);
    }
}

