/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ergoplatform.DataInput;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.ErgoScriptPredef;
import org.ergoplatform.UnsignedErgoLikeTransaction;
import org.ergoplatform.UnsignedInput;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.OutBoxBuilderImpl;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.appkit.impl.UnsignedTransactionImpl;
import org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext;
import scala.collection.IndexedSeq;
import special.collection.Coll;
import special.sigma.Header;
import special.sigma.PreHeader;

public class UnsignedTransactionBuilderImpl
implements UnsignedTransactionBuilder {
    private final BlockchainContextImpl _ctx;
    ArrayList<UnsignedInput> _inputs = new ArrayList();
    ArrayList<DataInput> _dataInputs = new ArrayList();
    ArrayList<ErgoBoxCandidate> _outputCandidates = new ArrayList();
    private List<InputBoxImpl> _inputBoxes;
    private long _feeAmount;
    private ErgoAddress _changeAddress;

    public UnsignedTransactionBuilderImpl(BlockchainContextImpl blockchainContextImpl) {
        this._ctx = blockchainContextImpl;
    }

    @Override
    public UnsignedTransactionBuilder boxesToSpend(List<InputBox> list) {
        List list2 = list.stream().map(inputBox -> JavaHelpers.createUnsignedInput(inputBox.getId().getBytes())).collect(Collectors.toList());
        this._inputs.addAll(list2);
        this._inputBoxes = list.stream().map(inputBox -> (InputBoxImpl)inputBox).collect(Collectors.toList());
        return this;
    }

    @Override
    public UnsignedTransactionBuilder outputs(OutBox ... outBoxArray) {
        Preconditions.checkState((boolean)this._outputCandidates.isEmpty(), (Object)"Outputs already specified.");
        this._outputCandidates = new ArrayList();
        this.appendOutputs(outBoxArray);
        return this;
    }

    @Override
    public UnsignedTransactionBuilder fee(long l) {
        Preconditions.checkState((this._feeAmount == 0L ? 1 : 0) != 0, (Object)"Fee already defined");
        this._feeAmount = l;
        return this;
    }

    private void appendOutputs(OutBox ... outBoxArray) {
        ErgoBoxCandidate[] ergoBoxCandidateArray = (ErgoBoxCandidate[])Stream.of(outBoxArray).map(outBox -> ((OutBoxImpl)outBox).getErgoBoxCandidate()).toArray(ErgoBoxCandidate[]::new);
        Collections.addAll(this._outputCandidates, ergoBoxCandidateArray);
    }

    @Override
    public UnsignedTransactionBuilder sendChangeTo(ErgoAddress ergoAddress) {
        Preconditions.checkState((this._changeAddress == null ? 1 : 0) != 0, (Object)"Change address is already specified");
        this._changeAddress = ergoAddress;
        return this;
    }

    @Override
    public UnsignedTransaction build() {
        IndexedSeq<UnsignedInput> indexedSeq = JavaHelpers.toIndexedSeq(this._inputs);
        IndexedSeq<DataInput> indexedSeq2 = JavaHelpers.toIndexedSeq(this._dataInputs);
        Preconditions.checkState((this._feeAmount > 0L ? 1 : 0) != 0, (Object)"Fee amount should be defined (using fee() method).");
        OutBox outBox = this.outBoxBuilder().value(this._feeAmount).contract(this._ctx.newContract(ErgoScriptPredef.feeProposition((int)720))).build();
        this.appendOutputs(outBox);
        Preconditions.checkState((this._changeAddress != null ? 1 : 0) != 0, (Object)"Change address is not defined");
        Long l3 = this._inputBoxes.stream().map(inputBoxImpl -> inputBoxImpl.getValue()).reduce(0L, (l, l2) -> l + l2);
        Long l4 = this._outputCandidates.stream().map(ergoBoxCandidate -> ergoBoxCandidate.value()).reduce(0L, (l, l2) -> l + l2);
        long l5 = l3 - l4;
        OutBox outBox2 = this.outBoxBuilder().value(l5).contract(this._ctx.newContract(this._changeAddress.script())).build();
        this.appendOutputs(outBox2);
        IndexedSeq<ErgoBoxCandidate> indexedSeq3 = JavaHelpers.toIndexedSeq(this._outputCandidates);
        UnsignedErgoLikeTransaction unsignedErgoLikeTransaction = new UnsignedErgoLikeTransaction(indexedSeq, indexedSeq2, indexedSeq3);
        List<ErgoBox> list = this._inputBoxes.stream().map(inputBoxImpl -> inputBoxImpl.getErgoBox()).collect(Collectors.toList());
        ErgoLikeStateContext ergoLikeStateContext = this.createErgoLikeStateContext();
        return new UnsignedTransactionImpl(unsignedErgoLikeTransaction, list, new ArrayList<ErgoBox>(), ergoLikeStateContext);
    }

    private ErgoLikeStateContext createErgoLikeStateContext() {
        return new ErgoLikeStateContext(){
            private Coll<Header> _allHeaders;
            private Coll<Header> _headers;
            private PreHeader _preHeader;
            {
                this._allHeaders = Iso.JListToColl(ScalaBridge.isoBlockHeader(), ErgoType.headerType().getRType()).to(UnsignedTransactionBuilderImpl.this._ctx.getHeaders());
                this._headers = this._allHeaders.slice(1, this._allHeaders.length());
                this._preHeader = JavaHelpers.toPreHeader((Header)this._allHeaders.apply(0));
            }

            public Coll<Header> sigmaLastHeaders() {
                return this._headers;
            }

            public byte[] previousStateDigest() {
                return JavaHelpers.getStateDigest(((Header)this._headers.apply(0)).stateRoot());
            }

            public PreHeader sigmaPreHeader() {
                return this._preHeader;
            }
        };
    }

    @Override
    public BlockchainContext getCtx() {
        return this._ctx;
    }

    @Override
    public OutBoxBuilder outBoxBuilder() {
        return new OutBoxBuilderImpl(this._ctx, this);
    }

    @Override
    public NetworkType getNetworkType() {
        return this._ctx.getNetworkType();
    }

    @Override
    public List<InputBox> getInputBoxes() {
        return this._inputBoxes.stream().collect(Collectors.toList());
    }
}

