/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Preconditions;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoAddressEncoder;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.NetworkType;
import scala.util.Try;
import scorex.util.encode.Base58;
import sigmastate.basics.DLogProtocol;

public class Address {
    private final String _base58String;
    private final byte[] _addrBytes;
    ErgoAddress _address;

    private byte headByte() {
        return this._addrBytes[0];
    }

    private Address(String string) {
        this._base58String = string;
        Try try_ = Base58.decode((String)string);
        if (try_.isFailure()) {
            throw new RuntimeException("Invalid address encoding, expected base58 string: " + string, (Throwable)try_.toEither().left().get());
        }
        this._addrBytes = (byte[])try_.get();
        ErgoAddressEncoder ergoAddressEncoder = ErgoAddressEncoder.apply((byte)this.getNetworkType().networkPrefix);
        Try try_2 = ergoAddressEncoder.fromString(string);
        if (try_2.isFailure()) {
            throw new RuntimeException("Invalid address encoding, expected base58 string: " + string, (Throwable)try_2.toEither().left().get());
        }
        this._address = (ErgoAddress)try_2.get();
    }

    public NetworkType getNetworkType() {
        return this.isMainnet() ? NetworkType.MAINNET : NetworkType.TESTNET;
    }

    public boolean isMainnet() {
        return this.headByte() < NetworkType.MAINNET.networkPrefix;
    }

    public boolean isP2PK() {
        return this._address instanceof P2PKAddress;
    }

    public DLogProtocol.ProveDlog getPublicKey() {
        Preconditions.checkArgument((boolean)this.isP2PK(), (String)"This instance %s is not P2PKAddress", (Object)this);
        return ((P2PKAddress)this._address).pubkey();
    }

    public static Address create(String string) {
        return new Address(string);
    }

    public String toString() {
        return this._address.toString();
    }
}

