/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ergoplatform.appkit.ErgoWallet;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.restapi.client.WalletBox;

public class ErgoWalletImpl
implements ErgoWallet {
    private final List<WalletBox> _unspentBoxesData;
    private BlockchainContextImpl _ctx;
    private List<InputBox> _unspentBoxes;

    public ErgoWalletImpl(List<WalletBox> list) {
        Preconditions.checkNotNull(list);
        this._unspentBoxesData = list;
    }

    void setContext(BlockchainContextImpl blockchainContextImpl) {
        Preconditions.checkState((this._ctx == null ? 1 : 0) != 0, (String)"Cannot reset context of wallet %s", (Object)this);
        this._ctx = blockchainContextImpl;
    }

    @Override
    public Optional<List<InputBox>> getUnspentBoxes(long l) {
        InputBox inputBox;
        if (this._unspentBoxes == null) {
            this._unspentBoxes = this._unspentBoxesData.stream().map(walletBox -> new InputBoxImpl(this._ctx, walletBox.getBox())).collect(Collectors.toList());
        }
        if (l == 0L) {
            return Optional.of(this._unspentBoxes);
        }
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        long l2 = 0L;
        for (int i = 0; i < this._unspentBoxes.size() && l2 < l; l2 += inputBox.getValue().longValue(), ++i) {
            inputBox = this._unspentBoxes.get(i);
            arrayList.add(inputBox);
        }
        if (l2 < l) {
            return Optional.empty();
        }
        return Optional.of(arrayList);
    }
}

