/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Holds many transaction requests and transaction fee")
public class RequestsHolder {
    @SerializedName(value="requests")
    private List<Object> requests = new ArrayList<Object>();
    @SerializedName(value="fee")
    private Long fee = null;
    @SerializedName(value="inputsRaw")
    private List<String> inputsRaw = null;

    public RequestsHolder requests(List<Object> list) {
        this.requests = list;
        return this;
    }

    public RequestsHolder addRequestsItem(Object object) {
        this.requests.add(object);
        return this;
    }

    @Schema(required=true, description="Sequence of transaction requests")
    public List<Object> getRequests() {
        return this.requests;
    }

    public void setRequests(List<Object> list) {
        this.requests = list;
    }

    public RequestsHolder fee(Long l) {
        this.fee = l;
        return this;
    }

    @Schema(example="1000000", description="Transaction fee")
    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long l) {
        this.fee = l;
    }

    public RequestsHolder inputsRaw(List<String> list) {
        this.inputsRaw = list;
        return this;
    }

    public RequestsHolder addInputsRawItem(String string) {
        if (this.inputsRaw == null) {
            this.inputsRaw = new ArrayList<String>();
        }
        this.inputsRaw.add(string);
        return this;
    }

    @Schema(description="List of inputs to be used in serialized form")
    public List<String> getInputsRaw() {
        return this.inputsRaw;
    }

    public void setInputsRaw(List<String> list) {
        this.inputsRaw = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RequestsHolder requestsHolder = (RequestsHolder)object;
        return Objects.equals(this.requests, requestsHolder.requests) && Objects.equals(this.fee, requestsHolder.fee) && Objects.equals(this.inputsRaw, requestsHolder.inputsRaw);
    }

    public int hashCode() {
        return Objects.hash(this.requests, this.fee, this.inputsRaw);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class RequestsHolder {\n");
        stringBuilder.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        stringBuilder.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        stringBuilder.append("    inputsRaw: ").append(this.toIndentedString(this.inputsRaw)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

