/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 0.1
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * WalletBox
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2019-10-19T14:53:04.559Z[GMT]")
public class WalletBox {
  @SerializedName("box")
  private ErgoTransactionOutput box = null;

  @SerializedName("confirmationsNum")
  private Integer confirmationsNum = null;

  @SerializedName("address")
  private String address = null;

  @SerializedName("creationTransaction")
  private String creationTransaction = null;

  @SerializedName("spendingTransaction")
  private String spendingTransaction = null;

  @SerializedName("spendingHeight")
  private Integer spendingHeight = null;

  @SerializedName("inclusionHeight")
  private Integer inclusionHeight = null;

  @SerializedName("certain")
  private Boolean certain = null;

  @SerializedName("onchain")
  private Boolean onchain = null;

  @SerializedName("spent")
  private Boolean spent = null;

  @SerializedName("creationOutIndex")
  private Integer creationOutIndex = null;

  @SerializedName("applicationId")
  private Integer applicationId = 1;

  public WalletBox box(ErgoTransactionOutput box) {
    this.box = box;
    return this;
  }

   /**
   * Get box
   * @return box
  **/
  @Schema(required = true, description = "")
  public ErgoTransactionOutput getBox() {
    return box;
  }

  public void setBox(ErgoTransactionOutput box) {
    this.box = box;
  }

  public WalletBox confirmationsNum(Integer confirmationsNum) {
    this.confirmationsNum = confirmationsNum;
    return this;
  }

   /**
   * Age of box in blocks
   * minimum: 0
   * @return confirmationsNum
  **/
  @Schema(example = "147", required = true, description = "Age of box in blocks")
  public Integer getConfirmationsNum() {
    return confirmationsNum;
  }

  public void setConfirmationsNum(Integer confirmationsNum) {
    this.confirmationsNum = confirmationsNum;
  }

  public WalletBox address(String address) {
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @Schema(required = true, description = "")
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public WalletBox creationTransaction(String creationTransaction) {
    this.creationTransaction = creationTransaction;
    return this;
  }

   /**
   * Get creationTransaction
   * @return creationTransaction
  **/
  @Schema(required = true, description = "")
  public String getCreationTransaction() {
    return creationTransaction;
  }

  public void setCreationTransaction(String creationTransaction) {
    this.creationTransaction = creationTransaction;
  }

  public WalletBox spendingTransaction(String spendingTransaction) {
    this.spendingTransaction = spendingTransaction;
    return this;
  }

   /**
   * Get spendingTransaction
   * @return spendingTransaction
  **/
  @Schema(required = true, description = "")
  public String getSpendingTransaction() {
    return spendingTransaction;
  }

  public void setSpendingTransaction(String spendingTransaction) {
    this.spendingTransaction = spendingTransaction;
  }

  public WalletBox spendingHeight(Integer spendingHeight) {
    this.spendingHeight = spendingHeight;
    return this;
  }

   /**
   * The height the box was spent at
   * minimum: 0
   * @return spendingHeight
  **/
  @Schema(example = "147", required = true, description = "The height the box was spent at")
  public Integer getSpendingHeight() {
    return spendingHeight;
  }

  public void setSpendingHeight(Integer spendingHeight) {
    this.spendingHeight = spendingHeight;
  }

  public WalletBox inclusionHeight(Integer inclusionHeight) {
    this.inclusionHeight = inclusionHeight;
    return this;
  }

   /**
   * The height the transaction containing the box was included in a block at
   * minimum: 0
   * @return inclusionHeight
  **/
  @Schema(example = "147", required = true, description = "The height the transaction containing the box was included in a block at")
  public Integer getInclusionHeight() {
    return inclusionHeight;
  }

  public void setInclusionHeight(Integer inclusionHeight) {
    this.inclusionHeight = inclusionHeight;
  }

  public WalletBox certain(Boolean certain) {
    this.certain = certain;
    return this;
  }

   /**
   * A flag signalling wheatehr the box is certainly resolved (as belonging to a wallet)
   * @return certain
  **/
  @Schema(example = "true", required = true, description = "A flag signalling wheatehr the box is certainly resolved (as belonging to a wallet)")
  public Boolean isCertain() {
    return certain;
  }

  public void setCertain(Boolean certain) {
    this.certain = certain;
  }

  public WalletBox onchain(Boolean onchain) {
    this.onchain = onchain;
    return this;
  }

   /**
   * A flag signalling wheatehr the box is created on main chain
   * @return onchain
  **/
  @Schema(example = "true", required = true, description = "A flag signalling wheatehr the box is created on main chain")
  public Boolean isOnchain() {
    return onchain;
  }

  public void setOnchain(Boolean onchain) {
    this.onchain = onchain;
  }

  public WalletBox spent(Boolean spent) {
    this.spent = spent;
    return this;
  }

   /**
   * A flag signalling wheatehr the box was spent
   * @return spent
  **/
  @Schema(example = "false", required = true, description = "A flag signalling wheatehr the box was spent")
  public Boolean isSpent() {
    return spent;
  }

  public void setSpent(Boolean spent) {
    this.spent = spent;
  }

  public WalletBox creationOutIndex(Integer creationOutIndex) {
    this.creationOutIndex = creationOutIndex;
    return this;
  }

   /**
   * An index of a box in transaction
   * @return creationOutIndex
  **/
  @Schema(example = "2", required = true, description = "An index of a box in transaction")
  public Integer getCreationOutIndex() {
    return creationOutIndex;
  }

  public void setCreationOutIndex(Integer creationOutIndex) {
    this.creationOutIndex = creationOutIndex;
  }

  public WalletBox applicationId(Integer applicationId) {
    this.applicationId = applicationId;
    return this;
  }

   /**
   * Application identifier a box relates to
   * @return applicationId
  **/
  @Schema(example = "1", required = true, description = "Application identifier a box relates to")
  public Integer getApplicationId() {
    return applicationId;
  }

  public void setApplicationId(Integer applicationId) {
    this.applicationId = applicationId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WalletBox walletBox = (WalletBox) o;
    return Objects.equals(this.box, walletBox.box) &&
        Objects.equals(this.confirmationsNum, walletBox.confirmationsNum) &&
        Objects.equals(this.address, walletBox.address) &&
        Objects.equals(this.creationTransaction, walletBox.creationTransaction) &&
        Objects.equals(this.spendingTransaction, walletBox.spendingTransaction) &&
        Objects.equals(this.spendingHeight, walletBox.spendingHeight) &&
        Objects.equals(this.inclusionHeight, walletBox.inclusionHeight) &&
        Objects.equals(this.certain, walletBox.certain) &&
        Objects.equals(this.onchain, walletBox.onchain) &&
        Objects.equals(this.spent, walletBox.spent) &&
        Objects.equals(this.creationOutIndex, walletBox.creationOutIndex) &&
        Objects.equals(this.applicationId, walletBox.applicationId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(box, confirmationsNum, address, creationTransaction, spendingTransaction, spendingHeight, inclusionHeight, certain, onchain, spent, creationOutIndex, applicationId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WalletBox {\n");
    
    sb.append("    box: ").append(toIndentedString(box)).append("\n");
    sb.append("    confirmationsNum: ").append(toIndentedString(confirmationsNum)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    creationTransaction: ").append(toIndentedString(creationTransaction)).append("\n");
    sb.append("    spendingTransaction: ").append(toIndentedString(spendingTransaction)).append("\n");
    sb.append("    spendingHeight: ").append(toIndentedString(spendingHeight)).append("\n");
    sb.append("    inclusionHeight: ").append(toIndentedString(inclusionHeight)).append("\n");
    sb.append("    certain: ").append(toIndentedString(certain)).append("\n");
    sb.append("    onchain: ").append(toIndentedString(onchain)).append("\n");
    sb.append("    spent: ").append(toIndentedString(spent)).append("\n");
    sb.append("    creationOutIndex: ").append(toIndentedString(creationOutIndex)).append("\n");
    sb.append("    applicationId: ").append(toIndentedString(applicationId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
