/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.examples.util;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.examples.util.MockedErgoClient;
import org.ergoplatform.appkit.impl.BlockchainContextBuilderImpl;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.restapi.client.ApiClient;
import scalan.util.FileUtil;

public class FileMockedErgoClient
implements MockedErgoClient {
    private final String _nodeInfoFile;
    private final String _lastHeadersFile;
    private final String _boxFile;

    public FileMockedErgoClient(String string, String string2, String string3) {
        this._nodeInfoFile = string;
        this._lastHeadersFile = string2;
        this._boxFile = string3;
    }

    @Override
    public String getNodeInfoResp() {
        return FileUtil.read((File)new File(this._nodeInfoFile));
    }

    @Override
    public String getLastHeadersResp() {
        return FileUtil.read((File)new File(this._lastHeadersFile));
    }

    @Override
    public String getBoxResp() {
        return FileUtil.read((File)new File(this._boxFile));
    }

    public <T> T execute(Function<BlockchainContext, T> function) {
        MockWebServer mockWebServer = new MockWebServer();
        MockWebServer mockWebServer2 = new MockWebServer();
        mockWebServer.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json; charset=utf-8").setBody(this.getNodeInfoResp()));
        mockWebServer.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json; charset=utf-8").setBody(this.getLastHeadersResp()));
        mockWebServer.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json; charset=utf-8").setBody(this.getBoxResp()));
        try {
            mockWebServer.start();
            mockWebServer2.start();
        }
        catch (IOException iOException) {
            throw new ErgoClientException("Cannot start server " + mockWebServer.toString(), (Throwable)iOException);
        }
        HttpUrl httpUrl = mockWebServer.url("/");
        ApiClient apiClient = new ApiClient(httpUrl.toString());
        HttpUrl httpUrl2 = mockWebServer2.url("/");
        ExplorerApiClient explorerApiClient = new ExplorerApiClient(httpUrl2.toString());
        BlockchainContext blockchainContext = new BlockchainContextBuilderImpl(apiClient, explorerApiClient, NetworkType.MAINNET).build();
        T t = function.apply(blockchainContext);
        try {
            mockWebServer.shutdown();
        }
        catch (IOException iOException) {
            throw new ErgoClientException("Cannot shutdown server " + mockWebServer.toString(), (Throwable)iOException);
        }
        return t;
    }
}

