/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.SecretStorage;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ErgoProverImpl;
import org.ergoplatform.restapi.client.Parameters;
import org.ergoplatform.wallet.interpreter.ErgoProvingInterpreter;
import org.ergoplatform.wallet.protocol.context.ErgoLikeParameters;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import scala.Option;

public class ErgoProverBuilderImpl
implements ErgoProverBuilder {
    private final BlockchainContextImpl _ctx;
    private ExtendedSecretKey _masterKey;

    public ErgoProverBuilderImpl(BlockchainContextImpl blockchainContextImpl) {
        this._ctx = blockchainContextImpl;
    }

    @Override
    public ErgoProverBuilder withMnemonic(String string, String string2) {
        this._masterKey = JavaHelpers.seedToMasterKey(string, string2);
        return this;
    }

    @Override
    public ErgoProverBuilder withMnemonic(Mnemonic mnemonic) {
        return this.withMnemonic(mnemonic.getPhrase(), mnemonic.getPassword());
    }

    @Override
    public ErgoProverBuilder withSecretStorage(SecretStorage secretStorage) {
        if (secretStorage.isLocked()) {
            throw new IllegalStateException("SecretStorage is locked, call unlock(password) method");
        }
        this._masterKey = secretStorage.getSecret();
        return null;
    }

    @Override
    public ErgoProver build() {
        ErgoLikeParameters ergoLikeParameters = new ErgoLikeParameters(){
            Parameters _params;
            {
                this._params = ErgoProverBuilderImpl.this._ctx.getNodeInfo().getParameters();
            }

            public int storageFeeFactor() {
                return this._params.getStorageFeeFactor();
            }

            public int minValuePerByte() {
                return this._params.getMinValuePerByte();
            }

            public int maxBlockSize() {
                return this._params.getMaxBlockSize();
            }

            public int tokenAccessCost() {
                return this._params.getTokenAccessCost();
            }

            public int inputCost() {
                return this._params.getInputCost();
            }

            public int dataInputCost() {
                return this._params.getDataInputCost();
            }

            public int outputCost() {
                return this._params.getOutputCost();
            }

            public long maxBlockCost() {
                return this._params.getMaxBlockCost().intValue();
            }

            public Option<Object> softForkStartingHeight() {
                return Option.apply((Object)0);
            }

            public Option<Object> softForkVotesCollected() {
                return Option.apply((Object)0);
            }

            public byte blockVersion() {
                return this._params.getBlockVersion().byteValue();
            }
        };
        ErgoProvingInterpreter ergoProvingInterpreter = ErgoProvingInterpreter.apply((ExtendedSecretKey)this._masterKey, (ErgoLikeParameters)ergoLikeParameters);
        return new ErgoProverImpl(this._ctx, ergoProvingInterpreter);
    }
}

