/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

public class BlockchainStatsMiningCost {
    @SerializedName(value="totalMinersRevenue")
    private BigDecimal totalMinersRevenue = null;
    @SerializedName(value="percentEarnedTransactionsFees")
    private BigDecimal percentEarnedTransactionsFees = null;
    @SerializedName(value="percentTransactionVolume")
    private BigDecimal percentTransactionVolume = null;
    @SerializedName(value="costPerTransaction")
    private BigDecimal costPerTransaction = null;
    @SerializedName(value="difficulty")
    private BigDecimal difficulty = null;
    @SerializedName(value="hashRate")
    private BigDecimal hashRate = null;

    public BlockchainStatsMiningCost totalMinersRevenue(BigDecimal bigDecimal) {
        this.totalMinersRevenue = bigDecimal;
        return this;
    }

    @Schema(example="439023010423", description="Total Miners Revenue")
    public BigDecimal getTotalMinersRevenue() {
        return this.totalMinersRevenue;
    }

    public void setTotalMinersRevenue(BigDecimal bigDecimal) {
        this.totalMinersRevenue = bigDecimal;
    }

    public BlockchainStatsMiningCost percentEarnedTransactionsFees(BigDecimal bigDecimal) {
        this.percentEarnedTransactionsFees = bigDecimal;
        return this;
    }

    @Schema(example="24.54", description="Miners revenue as percentage of the transaction fees")
    public BigDecimal getPercentEarnedTransactionsFees() {
        return this.percentEarnedTransactionsFees;
    }

    public void setPercentEarnedTransactionsFees(BigDecimal bigDecimal) {
        this.percentEarnedTransactionsFees = bigDecimal;
    }

    public BlockchainStatsMiningCost percentTransactionVolume(BigDecimal bigDecimal) {
        this.percentTransactionVolume = bigDecimal;
        return this;
    }

    @Schema(example="2.34", description="Miners revenue as percentage of the transaction volume")
    public BigDecimal getPercentTransactionVolume() {
        return this.percentTransactionVolume;
    }

    public void setPercentTransactionVolume(BigDecimal bigDecimal) {
        this.percentTransactionVolume = bigDecimal;
    }

    public BlockchainStatsMiningCost costPerTransaction(BigDecimal bigDecimal) {
        this.costPerTransaction = bigDecimal;
        return this;
    }

    @Schema(example="4323000", description="Miners revenue divided by the number of transactions")
    public BigDecimal getCostPerTransaction() {
        return this.costPerTransaction;
    }

    public void setCostPerTransaction(BigDecimal bigDecimal) {
        this.costPerTransaction = bigDecimal;
    }

    public BlockchainStatsMiningCost difficulty(BigDecimal bigDecimal) {
        this.difficulty = bigDecimal;
        return this;
    }

    @Schema(example="32340990000", description="Difficulty")
    public BigDecimal getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(BigDecimal bigDecimal) {
        this.difficulty = bigDecimal;
    }

    public BlockchainStatsMiningCost hashRate(BigDecimal bigDecimal) {
        this.hashRate = bigDecimal;
        return this;
    }

    @Schema(example="290349095", description="Hash Rate")
    public BigDecimal getHashRate() {
        return this.hashRate;
    }

    public void setHashRate(BigDecimal bigDecimal) {
        this.hashRate = bigDecimal;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlockchainStatsMiningCost blockchainStatsMiningCost = (BlockchainStatsMiningCost)object;
        return Objects.equals(this.totalMinersRevenue, blockchainStatsMiningCost.totalMinersRevenue) && Objects.equals(this.percentEarnedTransactionsFees, blockchainStatsMiningCost.percentEarnedTransactionsFees) && Objects.equals(this.percentTransactionVolume, blockchainStatsMiningCost.percentTransactionVolume) && Objects.equals(this.costPerTransaction, blockchainStatsMiningCost.costPerTransaction) && Objects.equals(this.difficulty, blockchainStatsMiningCost.difficulty) && Objects.equals(this.hashRate, blockchainStatsMiningCost.hashRate);
    }

    public int hashCode() {
        return Objects.hash(this.totalMinersRevenue, this.percentEarnedTransactionsFees, this.percentTransactionVolume, this.costPerTransaction, this.difficulty, this.hashRate);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class BlockchainStatsMiningCost {\n");
        stringBuilder.append("    totalMinersRevenue: ").append(this.toIndentedString(this.totalMinersRevenue)).append("\n");
        stringBuilder.append("    percentEarnedTransactionsFees: ").append(this.toIndentedString(this.percentEarnedTransactionsFees)).append("\n");
        stringBuilder.append("    percentTransactionVolume: ").append(this.toIndentedString(this.percentTransactionVolume)).append("\n");
        stringBuilder.append("    costPerTransaction: ").append(this.toIndentedString(this.costPerTransaction)).append("\n");
        stringBuilder.append("    difficulty: ").append(this.toIndentedString(this.difficulty)).append("\n");
        stringBuilder.append("    hashRate: ").append(this.toIndentedString(this.hashRate)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

