/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.ergoplatform.restapi.client.Registers;

@Schema(description="Request for generation of asset issue transaction")
public class AssetIssueRequest {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="amount")
    private Long amount = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="decimals")
    private Integer decimals = null;
    @SerializedName(value="fee")
    private Long fee = null;
    @SerializedName(value="registers")
    private Registers registers = null;

    public AssetIssueRequest address(String string) {
        this.address = string;
        return this;
    }

    @Schema(description="")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public AssetIssueRequest amount(Long l) {
        this.amount = l;
        return this;
    }

    @Schema(example="1000000", required=true, description="Supply amount")
    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long l) {
        this.amount = l;
    }

    public AssetIssueRequest name(String string) {
        this.name = string;
        return this;
    }

    @Schema(example="TST", required=true, description="Assets name")
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public AssetIssueRequest description(String string) {
        this.description = string;
        return this;
    }

    @Schema(example="Test token", required=true, description="Assets description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public AssetIssueRequest decimals(Integer n) {
        this.decimals = n;
        return this;
    }

    @Schema(example="8", required=true, description="Number of decimal places")
    public Integer getDecimals() {
        return this.decimals;
    }

    public void setDecimals(Integer n) {
        this.decimals = n;
    }

    public AssetIssueRequest fee(Long l) {
        this.fee = l;
        return this;
    }

    @Schema(example="1000000", description="Optional, default transaction fee from settings will be used if not defined")
    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long l) {
        this.fee = l;
    }

    public AssetIssueRequest registers(Registers registers) {
        this.registers = registers;
        return this;
    }

    @Schema(description="")
    public Registers getRegisters() {
        return this.registers;
    }

    public void setRegisters(Registers registers) {
        this.registers = registers;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AssetIssueRequest assetIssueRequest = (AssetIssueRequest)object;
        return Objects.equals(this.address, assetIssueRequest.address) && Objects.equals(this.amount, assetIssueRequest.amount) && Objects.equals(this.name, assetIssueRequest.name) && Objects.equals(this.description, assetIssueRequest.description) && Objects.equals(this.decimals, assetIssueRequest.decimals) && Objects.equals(this.fee, assetIssueRequest.fee) && Objects.equals(this.registers, assetIssueRequest.registers);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.amount, this.name, this.description, this.decimals, this.fee, this.registers);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class AssetIssueRequest {\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        stringBuilder.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        stringBuilder.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        stringBuilder.append("    decimals: ").append(this.toIndentedString(this.decimals)).append("\n");
        stringBuilder.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        stringBuilder.append("    registers: ").append(this.toIndentedString(this.registers)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

