/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.ArrayList;
import java.util.List;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.ConstantsBuilder;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.SecretStorage;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;

public class BoxOperations {
    public static List<InputBox> selectTop(List<InputBox> list, long l) {
        InputBox inputBox;
        if (l == 0L) {
            return list;
        }
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>();
        long l2 = 0L;
        for (int i = 0; i < list.size() && l2 < l; l2 += inputBox.getValue().longValue(), ++i) {
            inputBox = list.get(i);
            arrayList.add(inputBox);
        }
        if (l2 < l) {
            throw new RuntimeException("Not enough boxes to pay " + l);
        }
        return arrayList;
    }

    public static ErgoProver createProver(BlockchainContext blockchainContext, Mnemonic mnemonic) {
        ErgoProver ergoProver = blockchainContext.newProverBuilder().withMnemonic(mnemonic.getPhrase(), mnemonic.getPassword()).build();
        return ergoProver;
    }

    public static ErgoProver createProver(BlockchainContext blockchainContext, String string, String string2) {
        SecretStorage secretStorage = SecretStorage.loadFrom(string);
        secretStorage.unlock(string2);
        ErgoProver ergoProver = blockchainContext.newProverBuilder().withSecretStorage(secretStorage).build();
        return ergoProver;
    }

    public static String send(BlockchainContext blockchainContext, ErgoProver ergoProver, Address address, long l) {
        Address address2 = ergoProver.getAddress();
        List<InputBox> list = blockchainContext.getUnspentBoxesFor(address2);
        List<InputBox> list2 = BoxOperations.selectTop(list, l + 1000000L);
        UnsignedTransactionBuilder unsignedTransactionBuilder = blockchainContext.newTxBuilder();
        OutBox outBox = unsignedTransactionBuilder.outBoxBuilder().value(l).contract(blockchainContext.compileContract(ConstantsBuilder.create().item("recipientPk", address.getPublicKey()).build(), "{ recipientPk }")).build();
        UnsignedTransaction unsignedTransaction = unsignedTransactionBuilder.boxesToSpend(list2).outputs(outBox).fee(1000000L).sendChangeTo((ErgoAddress)ergoProver.getP2PKAddress()).build();
        SignedTransaction signedTransaction = ergoProver.sign(unsignedTransaction);
        blockchainContext.sendTransaction(signedTransaction);
        return signedTransaction.toJson(true);
    }
}

