/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.io.File;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import org.ergoplatform.wallet.secrets.JsonSecretStorage;
import org.ergoplatform.wallet.settings.EncryptionSettings;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Option;
import scala.util.Try;
import sigmastate.basics.DLogProtocol;

public class SecretStorage {
    public static EncryptionSettings DEFAULT_SETTINGS = new EncryptionSettings("HmacSHA256", 128000, 256);
    private final JsonSecretStorage _jsonStorage;

    SecretStorage(JsonSecretStorage jsonSecretStorage) {
        this._jsonStorage = jsonSecretStorage;
    }

    public boolean isLocked() {
        return this._jsonStorage.isLocked();
    }

    public File getFile() {
        return this._jsonStorage.secretFile();
    }

    public ExtendedSecretKey getSecret() {
        Option option = this._jsonStorage.secret();
        if (option.isEmpty()) {
            return null;
        }
        return (ExtendedSecretKey)option.get();
    }

    public Address getAddressFor(NetworkType networkType) {
        DLogProtocol.ProveDlog proveDlog = ((ExtendedSecretKey)this._jsonStorage.secret().get()).key().publicImage();
        P2PKAddress p2PKAddress = JavaHelpers.createP2PKAddress(proveDlog, networkType.networkPrefix);
        return new Address(p2PKAddress);
    }

    public void unlock(String string) {
        Try try_ = this._jsonStorage.unlock(string);
        if (try_.isFailure()) {
            Throwable throwable = (Throwable)try_.toEither().left().get();
            throw new RuntimeException("Cannot unlock secrete storage.", throwable);
        }
    }

    public static SecretStorage createFromMnemonicIn(String string, Mnemonic mnemonic, String string2) {
        Option<String> option = Iso.jstringToOptionString().to(mnemonic.getPassword());
        SecretStorageSettings secretStorageSettings = new SecretStorageSettings(string, DEFAULT_SETTINGS);
        JsonSecretStorage jsonSecretStorage = JsonSecretStorage.restore((String)mnemonic.getPhrase(), option, (String)string2, (SecretStorageSettings)secretStorageSettings);
        return new SecretStorage(jsonSecretStorage);
    }

    public static SecretStorage loadFrom(String string) {
        File file = new File(string);
        return SecretStorage.loadFrom(file);
    }

    public static SecretStorage loadFrom(File file) {
        if (!file.exists()) {
            throw new RuntimeException("SecreteStorage file not found: " + file.getPath());
        }
        return new SecretStorage(new JsonSecretStorage(file, DEFAULT_SETTINGS));
    }
}

