/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.SignedTransactionImpl;
import org.ergoplatform.appkit.impl.UnsignedTransactionImpl;
import org.ergoplatform.wallet.interpreter.ErgoProvingInterpreter;
import scala.collection.IndexedSeq;
import sigmastate.basics.DLogProtocol;

public class ErgoProverImpl
implements ErgoProver {
    private final BlockchainContextImpl _ctx;
    private final ErgoProvingInterpreter _prover;

    public ErgoProverImpl(BlockchainContextImpl blockchainContextImpl, ErgoProvingInterpreter ergoProvingInterpreter) {
        this._ctx = blockchainContextImpl;
        this._prover = ergoProvingInterpreter;
    }

    @Override
    public P2PKAddress getP2PKAddress() {
        DLogProtocol.ProveDlog proveDlog = ((DLogProtocol.DLogProverInput)this._prover.secrets().apply(0)).publicImage();
        return JavaHelpers.createP2PKAddress(proveDlog, this._ctx.getNetworkType().networkPrefix);
    }

    @Override
    public Address getAddress() {
        return new Address(this.getP2PKAddress());
    }

    @Override
    public SignedTransaction sign(UnsignedTransaction unsignedTransaction) {
        UnsignedTransactionImpl unsignedTransactionImpl = (UnsignedTransactionImpl)unsignedTransaction;
        IndexedSeq<ErgoBox> indexedSeq = JavaHelpers.toIndexedSeq(unsignedTransactionImpl.getBoxesToSpend());
        IndexedSeq<ErgoBox> indexedSeq2 = JavaHelpers.toIndexedSeq(unsignedTransactionImpl.getDataBoxes());
        ErgoLikeTransaction ergoLikeTransaction = (ErgoLikeTransaction)this._prover.sign(unsignedTransactionImpl.getTx(), indexedSeq, indexedSeq2, unsignedTransactionImpl.getStateContext()).get();
        return new SignedTransactionImpl(this._ctx, ergoLikeTransaction);
    }
}

