/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.gson.Gson;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.appkit.ErgoId;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.JSON;

public class InputBoxImpl
implements InputBox {
    private final BlockchainContextImpl _ctx;
    private final ErgoId _id;
    private final ErgoBox _ergoBox;
    private final ErgoTransactionOutput _boxData;

    public InputBoxImpl(BlockchainContextImpl blockchainContextImpl, ErgoTransactionOutput ergoTransactionOutput) {
        this._ctx = blockchainContextImpl;
        this._id = new ErgoId(JavaHelpers.decodeStringToBytes(ergoTransactionOutput.getBoxId()));
        this._ergoBox = ScalaBridge.isoErgoTransactionOutput().to(ergoTransactionOutput);
        this._boxData = ergoTransactionOutput;
    }

    public InputBoxImpl(BlockchainContextImpl blockchainContextImpl, ErgoBox ergoBox) {
        this._ctx = blockchainContextImpl;
        this._ergoBox = ergoBox;
        this._id = new ErgoId(ergoBox.id());
        this._boxData = ScalaBridge.isoErgoTransactionOutput().from(ergoBox);
    }

    @Override
    public ErgoId getId() {
        return this._id;
    }

    @Override
    public Long getValue() {
        return this._ergoBox.value();
    }

    @Override
    public String toJson(boolean bl) {
        Gson gson = bl ? JSON.createGson().setPrettyPrinting().create() : this._ctx.getApiClient().getGson();
        ErgoTransactionOutput ergoTransactionOutput = this._boxData;
        if (bl) {
            ergoTransactionOutput = this._ctx.getApiClient().cloneDataObject(this._boxData);
            ergoTransactionOutput.ergoTree(this._ergoBox.ergoTree().toString());
        }
        String string = gson.toJson((Object)ergoTransactionOutput);
        return string;
    }

    public ErgoBox getErgoBox() {
        return this._ergoBox;
    }

    public String toString() {
        return String.format("InputBox(%s, %s)", this.getId(), this.getValue());
    }
}

