/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.gson.Gson;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.JSON;
import sigmastate.Values;

public class SignedTransactionImpl
implements SignedTransaction {
    private final BlockchainContextImpl _ctx;
    private final ErgoLikeTransaction _tx;

    public SignedTransactionImpl(BlockchainContextImpl blockchainContextImpl, ErgoLikeTransaction ergoLikeTransaction) {
        this._ctx = blockchainContextImpl;
        this._tx = ergoLikeTransaction;
    }

    ErgoLikeTransaction getTx() {
        return this._tx;
    }

    public String toString() {
        return "Signed(" + this._tx + ")";
    }

    @Override
    public String getId() {
        return this._tx.id();
    }

    @Override
    public String toJson(boolean bl) {
        ErgoTransaction ergoTransaction = ScalaBridge.isoErgoTransaction().from(this._tx);
        if (bl) {
            ergoTransaction.getOutputs().forEach(ergoTransactionOutput -> {
                Values.ErgoTree ergoTree = ScalaBridge.isoStringToErgoTree().to(ergoTransactionOutput.getErgoTree());
                ergoTransactionOutput.ergoTree(ergoTree.toString());
            });
        }
        Gson gson = bl ? JSON.createGson().setPrettyPrinting().create() : this._ctx.getApiClient().getGson();
        String string = gson.toJson((Object)ergoTransaction);
        return string;
    }
}

