/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import com.google.common.base.Preconditions;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoAddressEncoder;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import scala.util.Try;
import scorex.util.encode.Base58;
import sigmastate.basics.DLogProtocol;
import sigmastate.utils.Helpers;

public class Address {
    private final String _base58String;
    private final byte[] _addrBytes;
    ErgoAddress _address;

    public Address(P2PKAddress p2PKAddress) {
        this._address = p2PKAddress;
        ErgoAddressEncoder ergoAddressEncoder = ErgoAddressEncoder.apply((byte)p2PKAddress.encoder().networkPrefix());
        this._base58String = ergoAddressEncoder.toString(this._address);
        this._addrBytes = (byte[])Base58.decode((String)this._base58String).get();
    }

    private byte headByte() {
        return this._addrBytes[0];
    }

    private Address(String string) {
        this._base58String = string;
        Try try_ = Base58.decode((String)string);
        if (try_.isFailure()) {
            throw new RuntimeException("Invalid address encoding, expected base58 string: " + string, (Throwable)new Helpers.TryOps(try_).toEither().left().get());
        }
        this._addrBytes = (byte[])try_.get();
        ErgoAddressEncoder ergoAddressEncoder = ErgoAddressEncoder.apply((byte)this.getNetworkType().networkPrefix);
        Try try_2 = ergoAddressEncoder.fromString(string);
        if (try_2.isFailure()) {
            throw new RuntimeException("Invalid address encoding, expected base58 string: " + string, (Throwable)new Helpers.TryOps(try_2).toEither().left().get());
        }
        this._address = (ErgoAddress)try_2.get();
    }

    public NetworkType getNetworkType() {
        return this.isMainnet() ? NetworkType.MAINNET : NetworkType.TESTNET;
    }

    public boolean isMainnet() {
        return this.headByte() < NetworkType.TESTNET.networkPrefix;
    }

    public boolean isP2PK() {
        return this._address instanceof P2PKAddress;
    }

    public ErgoAddress getErgoAddress() {
        return this._address;
    }

    public DLogProtocol.ProveDlog getPublicKey() {
        Preconditions.checkArgument((boolean)this.isP2PK(), (String)"This instance %s is not P2PKAddress", (Object)this);
        return ((P2PKAddress)this._address).pubkey();
    }

    public static Address create(String string) {
        return new Address(string);
    }

    public static Address fromMnemonic(NetworkType networkType, Mnemonic mnemonic) {
        return Address.fromMnemonic(networkType, mnemonic.getPhrase(), mnemonic.getPassword());
    }

    public static Address fromMnemonic(NetworkType networkType, String string, String string2) {
        ExtendedSecretKey extendedSecretKey = JavaHelpers.seedToMasterKey(string, string2);
        DLogProtocol.ProveDlog proveDlog = extendedSecretKey.key().publicImage();
        P2PKAddress p2PKAddress = JavaHelpers.createP2PKAddress(proveDlog, networkType.networkPrefix);
        return new Address(p2PKAddress);
    }

    public String toString() {
        return this._address.toString();
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Address) {
            return this._address.equals(((Address)object)._address);
        }
        return false;
    }
}

