/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ergoplatform.DataInput;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.Input;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.Constants;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.ErgoWallet;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.appkit.impl.ErgoNodeFacade;
import org.ergoplatform.appkit.impl.ErgoProverBuilderImpl;
import org.ergoplatform.appkit.impl.ErgoScriptContract;
import org.ergoplatform.appkit.impl.ErgoTreeContract;
import org.ergoplatform.appkit.impl.ErgoWalletImpl;
import org.ergoplatform.appkit.impl.ExplorerFacade;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.appkit.impl.SignedTransactionImpl;
import org.ergoplatform.appkit.impl.UnsignedTransactionBuilderImpl;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.explorer.client.model.TransactionOutput;
import org.ergoplatform.restapi.client.ApiClient;
import org.ergoplatform.restapi.client.BlockHeader;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionDataInput;
import org.ergoplatform.restapi.client.ErgoTransactionInput;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.NodeInfo;
import org.ergoplatform.restapi.client.WalletBox;
import retrofit2.Retrofit;
import scala.collection.IndexedSeq;
import sigmastate.Values;

public class BlockchainContextImpl
implements BlockchainContext {
    private final ApiClient _client;
    private final Retrofit _retrofit;
    private ExplorerApiClient _explorer;
    private Retrofit _retrofitExplorer;
    private final NetworkType _networkType;
    private final NodeInfo _nodeInfo;
    private final List<BlockHeader> _headers;
    private ErgoWalletImpl _wallet;

    public BlockchainContextImpl(ApiClient apiClient, Retrofit retrofit, ExplorerApiClient explorerApiClient, Retrofit retrofit2, NetworkType networkType, NodeInfo nodeInfo, List<BlockHeader> list) {
        this._client = apiClient;
        this._retrofit = retrofit;
        this._explorer = explorerApiClient;
        this._retrofitExplorer = retrofit2;
        this._networkType = networkType;
        this._nodeInfo = nodeInfo;
        this._headers = list;
    }

    @Override
    public UnsignedTransactionBuilder newTxBuilder() {
        return new UnsignedTransactionBuilderImpl(this);
    }

    @Override
    public InputBox[] getBoxesById(String ... stringArray) throws ErgoClientException {
        ArrayList<InputBoxImpl> arrayList = new ArrayList<InputBoxImpl>();
        for (String string : stringArray) {
            ErgoTransactionOutput ergoTransactionOutput = ErgoNodeFacade.getBoxById(this._retrofit, string);
            if (ergoTransactionOutput == null) {
                throw new ErgoClientException("Cannot load UTXO box " + string, null);
            }
            arrayList.add(new InputBoxImpl(this, ergoTransactionOutput));
        }
        Object[] objectArray = arrayList.toArray(new InputBox[0]);
        return objectArray;
    }

    @Override
    public ErgoProverBuilder newProverBuilder() {
        return new ErgoProverBuilderImpl(this);
    }

    @Override
    public NetworkType getNetworkType() {
        return this._networkType;
    }

    @Override
    public int getHeight() {
        return this._headers.get(0).getHeight();
    }

    Retrofit getRetrofit() {
        return this._retrofit;
    }

    ApiClient getApiClient() {
        return this._client;
    }

    public NodeInfo getNodeInfo() {
        return this._nodeInfo;
    }

    public List<BlockHeader> getHeaders() {
        return this._headers;
    }

    @Override
    public String sendTransaction(SignedTransaction signedTransaction) {
        ErgoLikeTransaction ergoLikeTransaction = ((SignedTransactionImpl)signedTransaction).getTx();
        List<ErgoTransactionDataInput> list = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionDataInput()).from((IndexedSeq<DataInput>)ergoLikeTransaction.dataInputs());
        List<ErgoTransactionInput> list2 = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionInput()).from((IndexedSeq<Input>)ergoLikeTransaction.inputs());
        List<ErgoTransactionOutput> list3 = Iso.JListToIndexedSeq(ScalaBridge.isoErgoTransactionOutput()).from((IndexedSeq<ErgoBox>)ergoLikeTransaction.outputs());
        ErgoTransaction ergoTransaction = new ErgoTransaction().id(ergoLikeTransaction.id()).dataInputs(list).inputs(list2).outputs(list3);
        String string = ErgoNodeFacade.sendTransaction(this._retrofit, ergoTransaction);
        return string;
    }

    @Override
    public ErgoWallet getWallet() {
        if (this._wallet == null) {
            List<WalletBox> list = ErgoNodeFacade.getWalletUnspentBoxes(this._retrofit, 0, 0);
            this._wallet = new ErgoWalletImpl(list);
            this._wallet.setContext(this);
        }
        return this._wallet;
    }

    @Override
    public ErgoContract newContract(Values.ErgoTree ergoTree) {
        return new ErgoTreeContract(ergoTree);
    }

    @Override
    public ErgoContract compileContract(Constants constants, String string) {
        return ErgoScriptContract.create(constants, string, this._networkType);
    }

    @Override
    public List<InputBox> getUnspentBoxesFor(Address address) {
        List<TransactionOutput> list = ExplorerFacade.transactionsBoxesByAddressUnspentIdGet(this._retrofitExplorer, address.toString());
        List<InputBox> list2 = list.stream().map(transactionOutput -> {
            String string = transactionOutput.getId();
            ErgoTransactionOutput ergoTransactionOutput = ErgoNodeFacade.getBoxById(this._retrofit, string);
            return new InputBoxImpl(this, ergoTransactionOutput);
        }).collect(Collectors.toList());
        return list2;
    }
}

