/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.ArrayList;
import java.util.List;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BoxOperations;
import org.ergoplatform.appkit.ConstantsBuilder;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoContracts;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import special.sigma.GroupElement;

public final class DhtUtils$ {
    public static DhtUtils$ MODULE$;
    private final String aliceStorage;
    private final String bobStorage;

    static {
        new DhtUtils$();
    }

    public String aliceStorage() {
        return this.aliceStorage;
    }

    public String bobStorage() {
        return this.bobStorage;
    }

    public SignedTransaction sendToDhtContractTx(BlockchainContext ctx, ErgoProver aliceProver, long amountToSend) {
        GroupElement g_x = aliceProver.getAddress().getPublicKeyGE();
        ErgoContract contract = ctx.compileContract(ConstantsBuilder.create().item("g_x", (Object)g_x).build(), new StringOps(Predef$.MODULE$.augmentString("{\n       |  val g_y = OUTPUTS(0).R4[GroupElement].get\n       |  val g_xy = OUTPUTS(0).R5[GroupElement].get\n       |\n       |  proveDHTuple(groupGenerator, g_x, g_y, g_xy) || // for bob\n       |  proveDHTuple(groupGenerator, g_y, g_x, g_xy)    // for alice\n       |}")).stripMargin());
        SignedTransaction aliceTx = BoxOperations.putToContractTx((BlockchainContext)ctx, (ErgoProver)aliceProver, (ErgoContract)contract, (long)amountToSend);
        return aliceTx;
    }

    public SignedTransaction spendDhtBox(BlockchainContext ctx, ErgoProver aliceProver, ErgoProver bobProver, InputBox dhtBox) {
        GroupElement g_x = aliceProver.getAddress().getPublicKeyGE();
        GroupElement g_y = bobProver.getAddress().getPublicKeyGE();
        GroupElement g_xy = g_x.exp(bobProver.getSecretKey());
        UnsignedTransactionBuilder txB = ctx.newTxBuilder();
        OutBox aliceBox = txB.outBoxBuilder().value(Predef$.MODULE$.Long2long(dhtBox.getValue())).contract(ErgoContracts.sendToPK((BlockchainContext)ctx, (Address)aliceProver.getAddress())).registers(new ErgoValue[]{ErgoValue.of((GroupElement)g_y), ErgoValue.of((GroupElement)g_xy)}).build();
        List boxesToPayFee = BoxOperations.loadTop((BlockchainContext)ctx, (Address)bobProver.getAddress(), (long)1000000L);
        ArrayList<InputBox> inputs = new ArrayList<InputBox>();
        inputs.add(dhtBox);
        inputs.addAll(boxesToPayFee);
        UnsignedTransaction tx = txB.boxesToSpend(inputs).outputs(new OutBox[]{aliceBox}).fee(1000000L).sendChangeTo((ErgoAddress)bobProver.getP2PKAddress()).build();
        SignedTransaction bobTx = bobProver.sign(tx);
        return bobTx;
    }

    private DhtUtils$() {
        MODULE$ = this;
        this.aliceStorage = "storage/E2.json";
        this.bobStorage = "storage/E1.json";
    }
}

