/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.ErgoClientException;
import org.ergoplatform.appkit.MockedErgoClient;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.impl.BlockchainContextBuilderImpl;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.restapi.client.ApiClient;

public class FileMockedErgoClient
implements MockedErgoClient {
    private final List<String> _nodeResponses;
    private final List<String> _explorerResponses;

    public FileMockedErgoClient(List<String> list, List<String> list2) {
        this._nodeResponses = list;
        this._explorerResponses = list2;
    }

    @Override
    public List<String> getNodeResponses() {
        return this._nodeResponses;
    }

    @Override
    public List<String> getExplorerResponses() {
        return this._explorerResponses;
    }

    void enqueueResponses(MockWebServer mockWebServer, List<String> list) {
        for (String string : list) {
            mockWebServer.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json; charset=utf-8").setBody(string));
        }
    }

    public <T> T execute(Function<BlockchainContext, T> function) {
        MockWebServer mockWebServer = new MockWebServer();
        this.enqueueResponses(mockWebServer, this._nodeResponses);
        MockWebServer mockWebServer2 = new MockWebServer();
        this.enqueueResponses(mockWebServer2, this._explorerResponses);
        try {
            mockWebServer.start();
            mockWebServer2.start();
        }
        catch (IOException iOException) {
            throw new ErgoClientException("Cannot start server " + mockWebServer.toString(), (Throwable)iOException);
        }
        HttpUrl httpUrl = mockWebServer.url("/");
        ApiClient apiClient = new ApiClient(httpUrl.toString());
        HttpUrl httpUrl2 = mockWebServer2.url("/");
        ExplorerApiClient explorerApiClient = new ExplorerApiClient(httpUrl2.toString());
        BlockchainContext blockchainContext = new BlockchainContextBuilderImpl(apiClient, explorerApiClient, NetworkType.MAINNET).build();
        T t = function.apply(blockchainContext);
        try {
            mockWebServer2.shutdown();
            mockWebServer.shutdown();
        }
        catch (IOException iOException) {
            throw new ErgoClientException("Cannot shutdown server " + mockWebServer.toString(), (Throwable)iOException);
        }
        return t;
    }
}

