/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.AppkitProvingInterpreter;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.SecretStorage;
import org.ergoplatform.appkit.SecretString;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ErgoProverImpl;
import org.ergoplatform.restapi.client.Parameters;
import org.ergoplatform.wallet.protocol.context.ErgoLikeParameters;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import scala.Option;
import sigmastate.basics.DiffieHellmanTupleProverInput;
import sigmastate.interpreter.CryptoConstants;
import special.sigma.GroupElement;

public class ErgoProverBuilderImpl
implements ErgoProverBuilder {
    private final BlockchainContextImpl _ctx;
    private ExtendedSecretKey _masterKey;
    private DiffieHellmanTupleProverInput _firstSecret;
    private DiffieHellmanTupleProverInput _secondSecret;

    public ErgoProverBuilderImpl(BlockchainContextImpl blockchainContextImpl) {
        this._ctx = blockchainContextImpl;
    }

    @Override
    public ErgoProverBuilder withMnemonic(SecretString secretString, SecretString secretString2) {
        this._masterKey = JavaHelpers.seedToMasterKey(secretString, secretString2);
        return this;
    }

    @Override
    public ErgoProverBuilder withMnemonic(Mnemonic mnemonic) {
        return this.withMnemonic(mnemonic.getPhrase(), mnemonic.getPassword());
    }

    @Override
    public ErgoProverBuilder withSecretStorage(SecretStorage secretStorage) {
        if (secretStorage.isLocked()) {
            throw new IllegalStateException("SecretStorage is locked, call unlock(password) method");
        }
        this._masterKey = secretStorage.getSecret();
        return this;
    }

    @Override
    public ErgoProverBuilder withFirstDHTSecret(Address address, GroupElement groupElement) {
        Preconditions.checkState((this._firstSecret == null ? 1 : 0) != 0, (Object)"First secret already defined.");
        BigInteger bigInteger = this._masterKey.key().w();
        SecP256K1Point secP256K1Point = this._masterKey.key().publicImage().value();
        SecP256K1Point secP256K1Point2 = address.getPublicKey().value();
        this._firstSecret = JavaHelpers.createDHTProverInput(secP256K1Point2, secP256K1Point, bigInteger, (SecP256K1Point)groupElement.value());
        return this;
    }

    @Override
    public ErgoProverBuilder withSecondDHTSecret(Address address) {
        Preconditions.checkState((this._secondSecret == null ? 1 : 0) != 0, (Object)"Second secret already defined.");
        BigInteger bigInteger = this._masterKey.key().w();
        SecP256K1Point secP256K1Point = this._masterKey.key().publicImage().value();
        SecP256K1Point secP256K1Point2 = address.getPublicKey().value();
        SecP256K1Point secP256K1Point3 = (SecP256K1Point)CryptoConstants.dlogGroup().exponentiate((ECPoint)secP256K1Point2, bigInteger);
        this._secondSecret = JavaHelpers.createDHTProverInput(secP256K1Point2, secP256K1Point, bigInteger, secP256K1Point3);
        return this;
    }

    @Override
    public ErgoProver build() {
        ErgoLikeParameters ergoLikeParameters = new ErgoLikeParameters(){
            Parameters _params;
            {
                this._params = ErgoProverBuilderImpl.this._ctx.getNodeInfo().getParameters();
            }

            public int storageFeeFactor() {
                return this._params.getStorageFeeFactor();
            }

            public int minValuePerByte() {
                return this._params.getMinValuePerByte();
            }

            public int maxBlockSize() {
                return this._params.getMaxBlockSize();
            }

            public int tokenAccessCost() {
                return this._params.getTokenAccessCost();
            }

            public int inputCost() {
                return this._params.getInputCost();
            }

            public int dataInputCost() {
                return this._params.getDataInputCost();
            }

            public int outputCost() {
                return this._params.getOutputCost();
            }

            public long maxBlockCost() {
                return this._params.getMaxBlockCost().intValue();
            }

            public Option<Object> softForkStartingHeight() {
                return Option.apply((Object)0);
            }

            public Option<Object> softForkVotesCollected() {
                return Option.apply((Object)0);
            }

            public byte blockVersion() {
                return this._params.getBlockVersion().byteValue();
            }
        };
        List<ExtendedSecretKey> list = Arrays.asList(this._masterKey);
        ArrayList<DiffieHellmanTupleProverInput> arrayList = new ArrayList<DiffieHellmanTupleProverInput>();
        if (this._firstSecret != null) {
            arrayList.add(this._firstSecret);
        }
        if (this._secondSecret != null) {
            arrayList.add(this._secondSecret);
        }
        AppkitProvingInterpreter appkitProvingInterpreter = new AppkitProvingInterpreter(list, arrayList, ergoLikeParameters);
        return new ErgoProverImpl(this._ctx, appkitProvingInterpreter);
    }
}

