/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.P2PKAddress;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.AppkitProvingInterpreter;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.SignedTransactionImpl;
import org.ergoplatform.appkit.impl.UnsignedTransactionImpl;
import scala.collection.IndexedSeq;
import sigmastate.basics.DLogProtocol;
import sigmastate.eval.CostingSigmaDslBuilder$;
import special.sigma.BigInt;

public class ErgoProverImpl
implements ErgoProver {
    private final BlockchainContextImpl _ctx;
    private final AppkitProvingInterpreter _prover;

    public ErgoProverImpl(BlockchainContextImpl blockchainContextImpl, AppkitProvingInterpreter appkitProvingInterpreter) {
        this._ctx = blockchainContextImpl;
        this._prover = appkitProvingInterpreter;
    }

    @Override
    public P2PKAddress getP2PKAddress() {
        DLogProtocol.ProveDlog proveDlog = (DLogProtocol.ProveDlog)this._prover.pubKeys().apply(0);
        return JavaHelpers.createP2PKAddress(proveDlog, this._ctx.getNetworkType().networkPrefix);
    }

    @Override
    public Address getAddress() {
        return new Address((ErgoAddress)this.getP2PKAddress());
    }

    @Override
    public BigInt getSecretKey() {
        return CostingSigmaDslBuilder$.MODULE$.BigInt(this._prover.secretKeys().get(0).privateInput().w());
    }

    @Override
    public SignedTransaction sign(UnsignedTransaction unsignedTransaction) {
        UnsignedTransactionImpl unsignedTransactionImpl = (UnsignedTransactionImpl)unsignedTransaction;
        IndexedSeq<ErgoBox> indexedSeq = JavaHelpers.toIndexedSeq(unsignedTransactionImpl.getBoxesToSpend());
        IndexedSeq<ErgoBox> indexedSeq2 = JavaHelpers.toIndexedSeq(unsignedTransactionImpl.getDataBoxes());
        ErgoLikeTransaction ergoLikeTransaction = (ErgoLikeTransaction)this._prover.sign(unsignedTransactionImpl.getTx(), indexedSeq, indexedSeq2, unsignedTransactionImpl.getStateContext()).get();
        return new SignedTransactionImpl(this._ctx, ergoLikeTransaction);
    }
}

