/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class BlockchainInfo {
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="supply")
    private Integer supply = null;
    @SerializedName(value="transactionAverage")
    private Integer transactionAverage = null;
    @SerializedName(value="hashRate")
    private Integer hashRate = null;

    public BlockchainInfo version(String string) {
        this.version = string;
        return this;
    }

    @Schema(example="1.0.0", required=true, description="Software version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public BlockchainInfo supply(Integer n) {
        this.supply = n;
        return this;
    }

    @Schema(example="1000003", required=true, description="Circulating supply")
    public Integer getSupply() {
        return this.supply;
    }

    public void setSupply(Integer n) {
        this.supply = n;
    }

    public BlockchainInfo transactionAverage(Integer n) {
        this.transactionAverage = n;
        return this;
    }

    @Schema(example="100302", required=true, description="Average number of transactions in block")
    public Integer getTransactionAverage() {
        return this.transactionAverage;
    }

    public void setTransactionAverage(Integer n) {
        this.transactionAverage = n;
    }

    public BlockchainInfo hashRate(Integer n) {
        this.hashRate = n;
        return this;
    }

    @Schema(example="415434144", required=true, description="Hashrate")
    public Integer getHashRate() {
        return this.hashRate;
    }

    public void setHashRate(Integer n) {
        this.hashRate = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlockchainInfo blockchainInfo = (BlockchainInfo)object;
        return Objects.equals(this.version, blockchainInfo.version) && Objects.equals(this.supply, blockchainInfo.supply) && Objects.equals(this.transactionAverage, blockchainInfo.transactionAverage) && Objects.equals(this.hashRate, blockchainInfo.hashRate);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.supply, this.transactionAverage, this.hashRate);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class BlockchainInfo {\n");
        stringBuilder.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        stringBuilder.append("    supply: ").append(this.toIndentedString(this.supply)).append("\n");
        stringBuilder.append("    transactionAverage: ").append(this.toIndentedString(this.transactionAverage)).append("\n");
        stringBuilder.append("    hashRate: ").append(this.toIndentedString(this.hashRate)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

