/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.Asset;
import org.ergoplatform.explorer.client.model.Registers;

public class UnconfirmedTransactionOutput {
    @SerializedName(value="boxId")
    private String boxId = null;
    @SerializedName(value="value")
    private BigDecimal value = null;
    @SerializedName(value="creationHeight")
    private Integer creationHeight = null;
    @SerializedName(value="ergoTree")
    private String ergoTree = null;
    @SerializedName(value="assets")
    private List<Asset> assets = new ArrayList<Asset>();
    @SerializedName(value="additionalRegisters")
    private Registers additionalRegisters = null;

    public UnconfirmedTransactionOutput boxId(String string) {
        this.boxId = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String string) {
        this.boxId = string;
    }

    public UnconfirmedTransactionOutput value(BigDecimal bigDecimal) {
        this.value = bigDecimal;
        return this;
    }

    @Schema(example="14.7", required=true, description="Amount of Ergo token")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public UnconfirmedTransactionOutput creationHeight(Integer n) {
        this.creationHeight = n;
        return this;
    }

    @Schema(example="9149", required=true, description="Height the output was created at")
    public Integer getCreationHeight() {
        return this.creationHeight;
    }

    public void setCreationHeight(Integer n) {
        this.creationHeight = n;
    }

    public UnconfirmedTransactionOutput ergoTree(String string) {
        this.ergoTree = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getErgoTree() {
        return this.ergoTree;
    }

    public void setErgoTree(String string) {
        this.ergoTree = string;
    }

    public UnconfirmedTransactionOutput assets(List<Asset> list) {
        this.assets = list;
        return this;
    }

    public UnconfirmedTransactionOutput addAssetsItem(Asset asset) {
        this.assets.add(asset);
        return this;
    }

    @Schema(required=true, description="Assets list in the transaction")
    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(List<Asset> list) {
        this.assets = list;
    }

    public UnconfirmedTransactionOutput additionalRegisters(Registers registers) {
        this.additionalRegisters = registers;
        return this;
    }

    @Schema(required=true, description="")
    public Registers getAdditionalRegisters() {
        return this.additionalRegisters;
    }

    public void setAdditionalRegisters(Registers registers) {
        this.additionalRegisters = registers;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UnconfirmedTransactionOutput unconfirmedTransactionOutput = (UnconfirmedTransactionOutput)object;
        return Objects.equals(this.boxId, unconfirmedTransactionOutput.boxId) && Objects.equals(this.value, unconfirmedTransactionOutput.value) && Objects.equals(this.creationHeight, unconfirmedTransactionOutput.creationHeight) && Objects.equals(this.ergoTree, unconfirmedTransactionOutput.ergoTree) && Objects.equals(this.assets, unconfirmedTransactionOutput.assets) && Objects.equals(this.additionalRegisters, unconfirmedTransactionOutput.additionalRegisters);
    }

    public int hashCode() {
        return Objects.hash(this.boxId, this.value, this.creationHeight, this.ergoTree, this.assets, this.additionalRegisters);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class UnconfirmedTransactionOutput {\n");
        stringBuilder.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        stringBuilder.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        stringBuilder.append("    creationHeight: ").append(this.toIndentedString(this.creationHeight)).append("\n");
        stringBuilder.append("    ergoTree: ").append(this.toIndentedString(this.ergoTree)).append("\n");
        stringBuilder.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        stringBuilder.append("    additionalRegisters: ").append(this.toIndentedString(this.additionalRegisters)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

