/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.function.Function;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.ErgoClient;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.config.ErgoNodeConfig;
import org.ergoplatform.appkit.impl.BlockchainContextBuilderImpl;
import org.ergoplatform.explorer.client.ExplorerApiClient;
import org.ergoplatform.restapi.client.ApiClient;

public class RestApiErgoClient
implements ErgoClient {
    private final String _nodeUrl;
    private final NetworkType _networkType;
    private final ApiClient _client;
    private final ExplorerApiClient _explorer;

    RestApiErgoClient(String string, NetworkType networkType, String string2) {
        this._nodeUrl = string;
        this._networkType = networkType;
        this._client = new ApiClient(this._nodeUrl, "ApiKeyAuth", string2);
        switch (networkType) {
            case MAINNET: {
                this._explorer = new ExplorerApiClient("https://api.ergoplatform.com");
                break;
            }
            default: {
                this._explorer = new ExplorerApiClient("https://api-testnet.ergoplatform.com");
            }
        }
    }

    @Override
    public <T> T execute(Function<BlockchainContext, T> function) {
        BlockchainContext blockchainContext = new BlockchainContextBuilderImpl(this._client, this._explorer, this._networkType).build();
        T t = function.apply(blockchainContext);
        return t;
    }

    public static ErgoClient create(String string, NetworkType networkType, String string2) {
        return new RestApiErgoClient(string, networkType, string2);
    }

    public static ErgoClient create(ErgoNodeConfig ergoNodeConfig) {
        return RestApiErgoClient.create(ergoNodeConfig.getNodeApi().getApiUrl(), ergoNodeConfig.getNetworkType(), ergoNodeConfig.getNodeApi().getApiKey());
    }

    ApiClient getNodeApiClient() {
        return this._client;
    }

    ExplorerApiClient getExplorerApiClient() {
        return this._explorer;
    }
}

