/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.appkit.ErgoContract;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.appkit.impl.UnsignedTransactionBuilderImpl;
import sigmastate.Values;
import special.collection.Coll;

public class OutBoxBuilderImpl
implements OutBoxBuilder {
    private final BlockchainContextImpl _ctx;
    private final UnsignedTransactionBuilderImpl _txB;
    private long _value = 0L;
    private ErgoContract _contract;
    private ArrayList<ErgoToken> _tokens = new ArrayList();
    private ArrayList<ErgoValue<?>> _registers = new ArrayList();

    public OutBoxBuilderImpl(BlockchainContextImpl blockchainContextImpl, UnsignedTransactionBuilderImpl unsignedTransactionBuilderImpl) {
        this._ctx = blockchainContextImpl;
        this._txB = unsignedTransactionBuilderImpl;
    }

    @Override
    public OutBoxBuilderImpl value(long l) {
        this._value = l;
        return this;
    }

    @Override
    public OutBoxBuilderImpl contract(ErgoContract ergoContract) {
        this._contract = ergoContract;
        return this;
    }

    @Override
    public OutBoxBuilderImpl tokens(ErgoToken ... ergoTokenArray) {
        Preconditions.checkArgument((ergoTokenArray.length > 0 ? 1 : 0) != 0, (Object)"At least one token should be specified");
        Collections.addAll(this._tokens, ergoTokenArray);
        return this;
    }

    @Override
    public OutBoxBuilder mintToken(ErgoToken ergoToken, String string, String string2, int n) {
        Charset charset = StandardCharsets.UTF_8;
        ErgoValue<Coll<Byte>> ergoValue = ErgoValue.of(string.getBytes(charset));
        ErgoValue<Coll<Byte>> ergoValue2 = ErgoValue.of(string2.getBytes(charset));
        ErgoValue<Coll<Byte>> ergoValue3 = ErgoValue.of(Integer.toString(n).getBytes(charset));
        Collections.addAll(this._registers, ergoValue, ergoValue2, ergoValue3);
        Collections.addAll(this._tokens, ergoToken);
        return this;
    }

    @Override
    public OutBoxBuilderImpl registers(ErgoValue<?> ... ergoValueArray) {
        Preconditions.checkArgument((ergoValueArray.length > 0 ? 1 : 0) != 0, (Object)"At least one register should be specified");
        Collections.addAll(this._registers, ergoValueArray);
        return this;
    }

    @Override
    public OutBox build() {
        Preconditions.checkState((this._contract != null ? 1 : 0) != 0, (Object)"Contract is not defined");
        Values.ErgoTree ergoTree = this._contract.getErgoTree();
        ErgoBoxCandidate ergoBoxCandidate = JavaHelpers.createBoxCandidate(this._value, ergoTree, this._tokens, this._registers, this._txB.getCtx().getHeight());
        return new OutBoxImpl(this._ctx, ergoBoxCandidate);
    }
}

