/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ergoplatform.DataInput;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.UnsignedErgoLikeTransaction;
import org.ergoplatform.UnsignedInput;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.Iso$;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.NetworkType;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.PreHeader;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.OutBoxBuilderImpl;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.appkit.impl.PreHeaderImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.appkit.impl.UnsignedTransactionImpl;
import org.ergoplatform.wallet.boxes.BoxSelector;
import org.ergoplatform.wallet.boxes.DefaultBoxSelector$;
import org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext;
import org.ergoplatform.wallet.transactions.TransactionBuilder;
import scala.collection.IndexedSeq;
import scala.collection.immutable.Map;
import special.collection.Coll;
import special.sigma.Header;

public class UnsignedTransactionBuilderImpl
implements UnsignedTransactionBuilder {
    private final BlockchainContextImpl _ctx;
    ArrayList<UnsignedInput> _inputs = new ArrayList();
    ArrayList<DataInput> _dataInputs = new ArrayList();
    ArrayList<ErgoBoxCandidate> _outputCandidates = new ArrayList();
    private List<InputBoxImpl> _inputBoxes;
    private List<InputBoxImpl> _dataInputBoxes = new ArrayList<InputBoxImpl>();
    private List<ErgoToken> _tokensToBurn = new ArrayList<ErgoToken>();
    private long _feeAmount;
    private ErgoAddress _changeAddress;
    private PreHeaderImpl _ph;

    public UnsignedTransactionBuilderImpl(BlockchainContextImpl blockchainContextImpl) {
        this._ctx = blockchainContextImpl;
    }

    @Override
    public UnsignedTransactionBuilder preHeader(PreHeader preHeader) {
        Preconditions.checkState((this._ph == null ? 1 : 0) != 0, (Object)"PreHeader is already specified");
        this._ph = (PreHeaderImpl)preHeader;
        return this;
    }

    @Override
    public UnsignedTransactionBuilder boxesToSpend(List<InputBox> list) {
        List list2 = list.stream().map(inputBox -> JavaHelpers.createUnsignedInput(inputBox.getId().getBytes())).collect(Collectors.toList());
        this._inputs.addAll(list2);
        this._inputBoxes = list.stream().map(inputBox -> (InputBoxImpl)inputBox).collect(Collectors.toList());
        return this;
    }

    @Override
    public UnsignedTransactionBuilder withDataInputs(List<InputBox> list) {
        List list2 = list.stream().map(inputBox -> JavaHelpers.createDataInput(inputBox.getId().getBytes())).collect(Collectors.toList());
        this._dataInputs.addAll(list2);
        this._dataInputBoxes = list.stream().map(inputBox -> (InputBoxImpl)inputBox).collect(Collectors.toList());
        return this;
    }

    @Override
    public UnsignedTransactionBuilder outputs(OutBox ... outBoxArray) {
        Preconditions.checkState((boolean)this._outputCandidates.isEmpty(), (Object)"Outputs already specified.");
        this._outputCandidates = new ArrayList();
        this.appendOutputs(outBoxArray);
        return this;
    }

    @Override
    public UnsignedTransactionBuilder fee(long l) {
        Preconditions.checkState((this._feeAmount == 0L ? 1 : 0) != 0, (Object)"Fee already defined");
        this._feeAmount = l;
        return this;
    }

    @Override
    public UnsignedTransactionBuilder tokensToBurn(ErgoToken ... ergoTokenArray) {
        this._tokensToBurn.addAll(Stream.of(ergoTokenArray).collect(Collectors.toList()));
        return this;
    }

    private void appendOutputs(OutBox ... outBoxArray) {
        ErgoBoxCandidate[] ergoBoxCandidateArray = (ErgoBoxCandidate[])Stream.of(outBoxArray).map(outBox -> ((OutBoxImpl)outBox).getErgoBoxCandidate()).toArray(ErgoBoxCandidate[]::new);
        Collections.addAll(this._outputCandidates, ergoBoxCandidateArray);
    }

    @Override
    public UnsignedTransactionBuilder sendChangeTo(ErgoAddress ergoAddress) {
        Preconditions.checkState((this._changeAddress == null ? 1 : 0) != 0, (Object)"Change address is already specified");
        this._changeAddress = ergoAddress;
        return this;
    }

    @Override
    public UnsignedTransaction build() {
        List<ErgoBox> list = this._inputBoxes.stream().map(inputBoxImpl -> inputBoxImpl.getErgoBox()).collect(Collectors.toList());
        List<ErgoBox> list2 = this._dataInputBoxes.stream().map(inputBoxImpl -> inputBoxImpl.getErgoBox()).collect(Collectors.toList());
        IndexedSeq<DataInput> indexedSeq = JavaHelpers.toIndexedSeq(this._dataInputs);
        Preconditions.checkState((this._feeAmount > 0L ? 1 : 0) != 0, (Object)"Fee amount should be defined (using fee() method).");
        Preconditions.checkState((this._feeAmount >= 1000000L ? 1 : 0) != 0, (Object)("Fee amount should be >= 1000000, got " + this._feeAmount));
        Preconditions.checkState((this._changeAddress != null ? 1 : 0) != 0, (Object)"Change address is not defined");
        IndexedSeq<ErgoBoxCandidate> indexedSeq2 = JavaHelpers.toIndexedSeq(this._outputCandidates);
        IndexedSeq indexedSeq3 = JavaHelpers.toIndexedSeq(list);
        Map<String, Object> map = JavaHelpers.createTokensMap(Iso$.MODULE$.isoJListErgoTokenToMapPair().to(this._tokensToBurn));
        DefaultBoxSelector$ defaultBoxSelector$ = DefaultBoxSelector$.MODULE$;
        UnsignedErgoLikeTransaction unsignedErgoLikeTransaction = (UnsignedErgoLikeTransaction)TransactionBuilder.buildUnsignedTx(indexedSeq3, indexedSeq, indexedSeq2, (int)this._ctx.getHeight(), (long)this._feeAmount, (ErgoAddress)this._changeAddress, (long)1000000L, (int)720, map, (BoxSelector)defaultBoxSelector$).get();
        ErgoLikeStateContext ergoLikeStateContext = this.createErgoLikeStateContext();
        return new UnsignedTransactionImpl(unsignedErgoLikeTransaction, list, list2, ergoLikeStateContext);
    }

    private ErgoLikeStateContext createErgoLikeStateContext() {
        return new ErgoLikeStateContext(){
            private Coll<Header> _allHeaders;
            private Coll<Header> _headers;
            private special.sigma.PreHeader _preHeader;
            {
                this._allHeaders = Iso.JListToColl(ScalaBridge.isoBlockHeader(), ErgoType.headerType().getRType()).to(UnsignedTransactionBuilderImpl.this._ctx.getHeaders());
                this._headers = this._allHeaders.slice(1, this._allHeaders.length());
                this._preHeader = UnsignedTransactionBuilderImpl.this._ph == null ? ((UnsignedTransactionBuilderImpl)UnsignedTransactionBuilderImpl.this)._ctx._preHeader._ph : ((UnsignedTransactionBuilderImpl)UnsignedTransactionBuilderImpl.this)._ph._ph;
            }

            public Coll<Header> sigmaLastHeaders() {
                return this._headers;
            }

            public byte[] previousStateDigest() {
                return JavaHelpers.getStateDigest(((Header)this._headers.apply(0)).stateRoot());
            }

            public special.sigma.PreHeader sigmaPreHeader() {
                return this._preHeader;
            }
        };
    }

    @Override
    public BlockchainContext getCtx() {
        return this._ctx;
    }

    @Override
    public PreHeader getPreHeader() {
        return this._ph == null ? this._ctx.getPreHeader() : this._ph;
    }

    @Override
    public OutBoxBuilder outBoxBuilder() {
        return new OutBoxBuilderImpl(this._ctx, this);
    }

    @Override
    public NetworkType getNetworkType() {
        return this._ctx.getNetworkType();
    }

    @Override
    public List<InputBox> getInputBoxes() {
        return this._inputBoxes.stream().collect(Collectors.toList());
    }
}

