/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 0.1
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.math.BigInteger;
import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;

/**
 * NodeInfo
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2019-10-19T14:53:04.559Z[GMT]")
public class NodeInfo {
  @SerializedName("name")
  private String name = null;

  @SerializedName("appVersion")
  private String appVersion = null;

  @SerializedName("fullHeight")
  private Integer fullHeight = null;

  @SerializedName("headersHeight")
  private Integer headersHeight = null;

  @SerializedName("bestFullHeaderId")
  private String bestFullHeaderId = null;

  @SerializedName("previousFullHeaderId")
  private String previousFullHeaderId = null;

  @SerializedName("bestHeaderId")
  private String bestHeaderId = null;

  @SerializedName("stateRoot")
  private String stateRoot = null;

  /**
   * Gets or Sets stateType
   */
  @JsonAdapter(StateTypeEnum.Adapter.class)
  public enum StateTypeEnum {
    DIGEST("digest"),
    UTXO("utxo");

    private String value;

    StateTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static StateTypeEnum fromValue(String text) {
      for (StateTypeEnum b : StateTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<StateTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StateTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StateTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return StateTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }  @SerializedName("stateType")
  private StateTypeEnum stateType = null;

  @SerializedName("stateVersion")
  private String stateVersion = null;

  @SerializedName("isMining")
  private Boolean isMining = null;

  @SerializedName("peersCount")
  private Integer peersCount = null;

  @SerializedName("unconfirmedCount")
  private Integer unconfirmedCount = null;

  @SerializedName("difficulty")
  private BigInteger difficulty = null;

  @SerializedName("currentTime")
  private Long currentTime = null;

  @SerializedName("launchTime")
  private Long launchTime = null;

  @SerializedName("headersScore")
  private BigInteger headersScore = null;

  @SerializedName("fullBlocksScore")
  private BigInteger fullBlocksScore = null;

  @SerializedName("genesisBlockId")
  private String genesisBlockId = null;

  @SerializedName("parameters")
  private Parameters parameters = null;

  public NodeInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(example = "my-node-1", required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public NodeInfo appVersion(String appVersion) {
    this.appVersion = appVersion;
    return this;
  }

   /**
   * Get appVersion
   * @return appVersion
  **/
  @Schema(example = "0.0.1", required = true, description = "")
  public String getAppVersion() {
    return appVersion;
  }

  public void setAppVersion(String appVersion) {
    this.appVersion = appVersion;
  }

  public NodeInfo fullHeight(Integer fullHeight) {
    this.fullHeight = fullHeight;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if state is empty (no full block is applied since node launch)
   * minimum: 0
   * @return fullHeight
  **/
  @Schema(example = "667", required = true, description = "Can be 'null' if state is empty (no full block is applied since node launch)")
  public Integer getFullHeight() {
    return fullHeight;
  }

  public void setFullHeight(Integer fullHeight) {
    this.fullHeight = fullHeight;
  }

  public NodeInfo headersHeight(Integer headersHeight) {
    this.headersHeight = headersHeight;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if state is empty (no header applied since node launch)
   * minimum: 0
   * @return headersHeight
  **/
  @Schema(example = "667", required = true, description = "Can be 'null' if state is empty (no header applied since node launch)")
  public Integer getHeadersHeight() {
    return headersHeight;
  }

  public void setHeadersHeight(Integer headersHeight) {
    this.headersHeight = headersHeight;
  }

  public NodeInfo bestFullHeaderId(String bestFullHeaderId) {
    this.bestFullHeaderId = bestFullHeaderId;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if no full block is applied since node launch
   * @return bestFullHeaderId
  **/
  @Schema(required = true, description = "Can be 'null' if no full block is applied since node launch")
  public String getBestFullHeaderId() {
    return bestFullHeaderId;
  }

  public void setBestFullHeaderId(String bestFullHeaderId) {
    this.bestFullHeaderId = bestFullHeaderId;
  }

  public NodeInfo previousFullHeaderId(String previousFullHeaderId) {
    this.previousFullHeaderId = previousFullHeaderId;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if no full block is applied since node launch
   * @return previousFullHeaderId
  **/
  @Schema(required = true, description = "Can be 'null' if no full block is applied since node launch")
  public String getPreviousFullHeaderId() {
    return previousFullHeaderId;
  }

  public void setPreviousFullHeaderId(String previousFullHeaderId) {
    this.previousFullHeaderId = previousFullHeaderId;
  }

  public NodeInfo bestHeaderId(String bestHeaderId) {
    this.bestHeaderId = bestHeaderId;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if no header applied since node launch
   * @return bestHeaderId
  **/
  @Schema(required = true, description = "Can be 'null' if no header applied since node launch")
  public String getBestHeaderId() {
    return bestHeaderId;
  }

  public void setBestHeaderId(String bestHeaderId) {
    this.bestHeaderId = bestHeaderId;
  }

  public NodeInfo stateRoot(String stateRoot) {
    this.stateRoot = stateRoot;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if state is empty (no full block is applied since node launch)
   * @return stateRoot
  **/
  @Schema(example = "dab9da11fc216660e974842cc3b7705e62ebb9e0bf5ff78e53f9cd40abadd117", required = true, description = "Can be 'null' if state is empty (no full block is applied since node launch)")
  public String getStateRoot() {
    return stateRoot;
  }

  public void setStateRoot(String stateRoot) {
    this.stateRoot = stateRoot;
  }

  public NodeInfo stateType(StateTypeEnum stateType) {
    this.stateType = stateType;
    return this;
  }

   /**
   * Get stateType
   * @return stateType
  **/
  @Schema(required = true, description = "")
  public StateTypeEnum getStateType() {
    return stateType;
  }

  public void setStateType(StateTypeEnum stateType) {
    this.stateType = stateType;
  }

  public NodeInfo stateVersion(String stateVersion) {
    this.stateVersion = stateVersion;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if no full block is applied since node launch
   * @return stateVersion
  **/
  @Schema(example = "fab9da11fc216660e974842cc3b7705e62ebb9e0bf5ff78e53f9cd40abadd117", required = true, description = "Can be 'null' if no full block is applied since node launch")
  public String getStateVersion() {
    return stateVersion;
  }

  public void setStateVersion(String stateVersion) {
    this.stateVersion = stateVersion;
  }

  public NodeInfo isMining(Boolean isMining) {
    this.isMining = isMining;
    return this;
  }

   /**
   * Get isMining
   * @return isMining
  **/
  @Schema(example = "true", required = true, description = "")
  public Boolean isIsMining() {
    return isMining;
  }

  public void setIsMining(Boolean isMining) {
    this.isMining = isMining;
  }

  public NodeInfo peersCount(Integer peersCount) {
    this.peersCount = peersCount;
    return this;
  }

   /**
   * Number of connected peers
   * minimum: 0
   * @return peersCount
  **/
  @Schema(example = "327", required = true, description = "Number of connected peers")
  public Integer getPeersCount() {
    return peersCount;
  }

  public void setPeersCount(Integer peersCount) {
    this.peersCount = peersCount;
  }

  public NodeInfo unconfirmedCount(Integer unconfirmedCount) {
    this.unconfirmedCount = unconfirmedCount;
    return this;
  }

   /**
   * Current unconfirmed transactions count
   * minimum: 0
   * maximum: 10000
   * @return unconfirmedCount
  **/
  @Schema(example = "327", required = true, description = "Current unconfirmed transactions count")
  public Integer getUnconfirmedCount() {
    return unconfirmedCount;
  }

  public void setUnconfirmedCount(Integer unconfirmedCount) {
    this.unconfirmedCount = unconfirmedCount;
  }

  public NodeInfo difficulty(BigInteger difficulty) {
    this.difficulty = difficulty;
    return this;
  }

   /**
   * Difficulty on current bestFullHeaderId. Can be &#x27;null&#x27; if no full block is applied since node launch
   * minimum: 0
   * @return difficulty
  **/
  @Schema(example = "667", required = true, description = "Difficulty on current bestFullHeaderId. Can be 'null' if no full block is applied since node launch")
  public BigInteger getDifficulty() {
    return difficulty;
  }

  public void setDifficulty(BigInteger difficulty) {
    this.difficulty = difficulty;
  }

  public NodeInfo currentTime(Long currentTime) {
    this.currentTime = currentTime;
    return this;
  }

   /**
   * Current internal node time
   * @return currentTime
  **/
  @Schema(required = true, description = "Current internal node time")
  public Long getCurrentTime() {
    return currentTime;
  }

  public void setCurrentTime(Long currentTime) {
    this.currentTime = currentTime;
  }

  public NodeInfo launchTime(Long launchTime) {
    this.launchTime = launchTime;
    return this;
  }

   /**
   * Time when the node was started
   * @return launchTime
  **/
  @Schema(required = true, description = "Time when the node was started")
  public Long getLaunchTime() {
    return launchTime;
  }

  public void setLaunchTime(Long launchTime) {
    this.launchTime = launchTime;
  }

  public NodeInfo headersScore(BigInteger headersScore) {
    this.headersScore = headersScore;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if no headers is applied since node launch
   * @return headersScore
  **/
  @Schema(required = true, description = "Can be 'null' if no headers is applied since node launch")
  public BigInteger getHeadersScore() {
    return headersScore;
  }

  public void setHeadersScore(BigInteger headersScore) {
    this.headersScore = headersScore;
  }

  public NodeInfo fullBlocksScore(BigInteger fullBlocksScore) {
    this.fullBlocksScore = fullBlocksScore;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if no full block is applied since node launch
   * @return fullBlocksScore
  **/
  @Schema(required = true, description = "Can be 'null' if no full block is applied since node launch")
  public BigInteger getFullBlocksScore() {
    return fullBlocksScore;
  }

  public void setFullBlocksScore(BigInteger fullBlocksScore) {
    this.fullBlocksScore = fullBlocksScore;
  }

  public NodeInfo genesisBlockId(String genesisBlockId) {
    this.genesisBlockId = genesisBlockId;
    return this;
  }

   /**
   * Can be &#x27;null&#x27; if genesis blocks is not produced yet
   * @return genesisBlockId
  **/
  @Schema(required = true, description = "Can be 'null' if genesis blocks is not produced yet")
  public String getGenesisBlockId() {
    return genesisBlockId;
  }

  public void setGenesisBlockId(String genesisBlockId) {
    this.genesisBlockId = genesisBlockId;
  }

  public NodeInfo parameters(Parameters parameters) {
    this.parameters = parameters;
    return this;
  }

   /**
   * Get parameters
   * @return parameters
  **/
  @Schema(required = true, description = "")
  public Parameters getParameters() {
    return parameters;
  }

  public void setParameters(Parameters parameters) {
    this.parameters = parameters;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NodeInfo nodeInfo = (NodeInfo) o;
    return Objects.equals(this.name, nodeInfo.name) &&
        Objects.equals(this.appVersion, nodeInfo.appVersion) &&
        Objects.equals(this.fullHeight, nodeInfo.fullHeight) &&
        Objects.equals(this.headersHeight, nodeInfo.headersHeight) &&
        Objects.equals(this.bestFullHeaderId, nodeInfo.bestFullHeaderId) &&
        Objects.equals(this.previousFullHeaderId, nodeInfo.previousFullHeaderId) &&
        Objects.equals(this.bestHeaderId, nodeInfo.bestHeaderId) &&
        Objects.equals(this.stateRoot, nodeInfo.stateRoot) &&
        Objects.equals(this.stateType, nodeInfo.stateType) &&
        Objects.equals(this.stateVersion, nodeInfo.stateVersion) &&
        Objects.equals(this.isMining, nodeInfo.isMining) &&
        Objects.equals(this.peersCount, nodeInfo.peersCount) &&
        Objects.equals(this.unconfirmedCount, nodeInfo.unconfirmedCount) &&
        Objects.equals(this.difficulty, nodeInfo.difficulty) &&
        Objects.equals(this.currentTime, nodeInfo.currentTime) &&
        Objects.equals(this.launchTime, nodeInfo.launchTime) &&
        Objects.equals(this.headersScore, nodeInfo.headersScore) &&
        Objects.equals(this.fullBlocksScore, nodeInfo.fullBlocksScore) &&
        Objects.equals(this.genesisBlockId, nodeInfo.genesisBlockId) &&
        Objects.equals(this.parameters, nodeInfo.parameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, appVersion, fullHeight, headersHeight, bestFullHeaderId, previousFullHeaderId, bestHeaderId, stateRoot, stateType, stateVersion, isMining, peersCount, unconfirmedCount, difficulty, currentTime, launchTime, headersScore, fullBlocksScore, genesisBlockId, parameters);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NodeInfo {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    appVersion: ").append(toIndentedString(appVersion)).append("\n");
    sb.append("    fullHeight: ").append(toIndentedString(fullHeight)).append("\n");
    sb.append("    headersHeight: ").append(toIndentedString(headersHeight)).append("\n");
    sb.append("    bestFullHeaderId: ").append(toIndentedString(bestFullHeaderId)).append("\n");
    sb.append("    previousFullHeaderId: ").append(toIndentedString(previousFullHeaderId)).append("\n");
    sb.append("    bestHeaderId: ").append(toIndentedString(bestHeaderId)).append("\n");
    sb.append("    stateRoot: ").append(toIndentedString(stateRoot)).append("\n");
    sb.append("    stateType: ").append(toIndentedString(stateType)).append("\n");
    sb.append("    stateVersion: ").append(toIndentedString(stateVersion)).append("\n");
    sb.append("    isMining: ").append(toIndentedString(isMining)).append("\n");
    sb.append("    peersCount: ").append(toIndentedString(peersCount)).append("\n");
    sb.append("    unconfirmedCount: ").append(toIndentedString(unconfirmedCount)).append("\n");
    sb.append("    difficulty: ").append(toIndentedString(difficulty)).append("\n");
    sb.append("    currentTime: ").append(toIndentedString(currentTime)).append("\n");
    sb.append("    launchTime: ").append(toIndentedString(launchTime)).append("\n");
    sb.append("    headersScore: ").append(toIndentedString(headersScore)).append("\n");
    sb.append("    fullBlocksScore: ").append(toIndentedString(fullBlocksScore)).append("\n");
    sb.append("    genesisBlockId: ").append(toIndentedString(genesisBlockId)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
