/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 0.1
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.ArrayList;
import java.util.List;
/**
 * Holds many transaction requests and transaction fee
 */
@Schema(description = "Holds many transaction requests and transaction fee")
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2019-10-19T14:53:04.559Z[GMT]")
public class RequestsHolder {
  @SerializedName("requests")
  private List<Object> requests = new ArrayList<>();

  @SerializedName("fee")
  private Long fee = null;

  @SerializedName("inputsRaw")
  private List<String> inputsRaw = null;

  public RequestsHolder requests(List<Object> requests) {
    this.requests = requests;
    return this;
  }

  public RequestsHolder addRequestsItem(Object requestsItem) {
    this.requests.add(requestsItem);
    return this;
  }

   /**
   * Sequence of transaction requests
   * @return requests
  **/
  @Schema(required = true, description = "Sequence of transaction requests")
  public List<Object> getRequests() {
    return requests;
  }

  public void setRequests(List<Object> requests) {
    this.requests = requests;
  }

  public RequestsHolder fee(Long fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Transaction fee
   * @return fee
  **/
  @Schema(example = "1000000", description = "Transaction fee")
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public RequestsHolder inputsRaw(List<String> inputsRaw) {
    this.inputsRaw = inputsRaw;
    return this;
  }

  public RequestsHolder addInputsRawItem(String inputsRawItem) {
    if (this.inputsRaw == null) {
      this.inputsRaw = new ArrayList<>();
    }
    this.inputsRaw.add(inputsRawItem);
    return this;
  }

   /**
   * List of inputs to be used in serialized form
   * @return inputsRaw
  **/
  @Schema(description = "List of inputs to be used in serialized form")
  public List<String> getInputsRaw() {
    return inputsRaw;
  }

  public void setInputsRaw(List<String> inputsRaw) {
    this.inputsRaw = inputsRaw;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RequestsHolder requestsHolder = (RequestsHolder) o;
    return Objects.equals(this.requests, requestsHolder.requests) &&
        Objects.equals(this.fee, requestsHolder.fee) &&
        Objects.equals(this.inputsRaw, requestsHolder.inputsRaw);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requests, fee, inputsRaw);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RequestsHolder {\n");
    
    sb.append("    requests: ").append(toIndentedString(requests)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    inputsRaw: ").append(toIndentedString(inputsRaw)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
