/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import org.ergoplatform.appkit.AppkitProvingInterpreter;
import org.ergoplatform.appkit.ErgoProver;
import org.ergoplatform.appkit.ErgoProverBuilder;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.Mnemonic;
import org.ergoplatform.appkit.SecretStorage;
import org.ergoplatform.appkit.SecretString;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ErgoProverImpl;
import org.ergoplatform.restapi.client.Parameters;
import org.ergoplatform.wallet.protocol.context.ErgoLikeParameters;
import org.ergoplatform.wallet.secrets.ExtendedSecretKey;
import scala.Option;
import sigmastate.basics.DLogProtocol;
import sigmastate.basics.DiffieHellmanTupleProverInput;
import special.sigma.GroupElement;

public class ErgoProverBuilderImpl
implements ErgoProverBuilder {
    private final BlockchainContextImpl _ctx;
    private ExtendedSecretKey _masterKey;
    private ArrayList<DiffieHellmanTupleProverInput> _dhtSecrets = new ArrayList();
    private ArrayList<DLogProtocol.DLogProverInput> _dLogSecrets = new ArrayList();

    public ErgoProverBuilderImpl(BlockchainContextImpl blockchainContextImpl) {
        this._ctx = blockchainContextImpl;
    }

    @Override
    public ErgoProverBuilder withMnemonic(SecretString secretString, SecretString secretString2) {
        this._masterKey = JavaHelpers.seedToMasterKey(secretString, secretString2);
        return this;
    }

    @Override
    public ErgoProverBuilder withMnemonic(Mnemonic mnemonic) {
        return this.withMnemonic(mnemonic.getPhrase(), mnemonic.getPassword());
    }

    @Override
    public ErgoProverBuilder withSecretStorage(SecretStorage secretStorage) {
        if (secretStorage.isLocked()) {
            throw new IllegalStateException("SecretStorage is locked, call unlock(password) method");
        }
        this._masterKey = secretStorage.getSecret();
        return this;
    }

    @Override
    public ErgoProverBuilder withDHTData(GroupElement groupElement, GroupElement groupElement2, GroupElement groupElement3, GroupElement groupElement4, BigInteger bigInteger) {
        DiffieHellmanTupleProverInput diffieHellmanTupleProverInput = JavaHelpers.createDiffieHellmanTupleProverInput((SecP256K1Point)groupElement.value(), (SecP256K1Point)groupElement2.value(), (SecP256K1Point)groupElement3.value(), (SecP256K1Point)groupElement4.value(), bigInteger);
        if (this._dhtSecrets.contains(diffieHellmanTupleProverInput)) {
            throw new IllegalStateException("DHTuple secret already exists");
        }
        this._dhtSecrets.add(diffieHellmanTupleProverInput);
        return this;
    }

    @Override
    public ErgoProverBuilder withDLogSecret(BigInteger bigInteger) {
        DLogProtocol.DLogProverInput dLogProverInput = new DLogProtocol.DLogProverInput(bigInteger);
        if (this._dLogSecrets.contains(dLogProverInput)) {
            throw new IllegalStateException("Dlog secret already exists");
        }
        this._dLogSecrets.add(dLogProverInput);
        return this;
    }

    @Override
    public ErgoProver build() {
        ErgoLikeParameters ergoLikeParameters = new ErgoLikeParameters(){
            Parameters _params;
            {
                this._params = ErgoProverBuilderImpl.this._ctx.getNodeInfo().getParameters();
            }

            public int storageFeeFactor() {
                return this._params.getStorageFeeFactor();
            }

            public int minValuePerByte() {
                return this._params.getMinValuePerByte();
            }

            public int maxBlockSize() {
                return this._params.getMaxBlockSize();
            }

            public int tokenAccessCost() {
                return this._params.getTokenAccessCost();
            }

            public int inputCost() {
                return this._params.getInputCost();
            }

            public int dataInputCost() {
                return this._params.getDataInputCost();
            }

            public int outputCost() {
                return this._params.getOutputCost();
            }

            public long maxBlockCost() {
                return this._params.getMaxBlockCost().intValue();
            }

            public Option<Object> softForkStartingHeight() {
                return Option.apply((Object)0);
            }

            public Option<Object> softForkVotesCollected() {
                return Option.apply((Object)0);
            }

            public byte blockVersion() {
                return this._params.getBlockVersion().byteValue();
            }
        };
        ArrayList<ExtendedSecretKey> arrayList = new ArrayList<ExtendedSecretKey>();
        if (this._masterKey != null) {
            arrayList.add(this._masterKey);
        }
        AppkitProvingInterpreter appkitProvingInterpreter = new AppkitProvingInterpreter(arrayList, this._dLogSecrets, this._dhtSecrets, ergoLikeParameters);
        return new ErgoProverImpl(this._ctx, appkitProvingInterpreter);
    }
}

