/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.ErgoTransactionDataInput;
import org.ergoplatform.restapi.client.ErgoTransactionInput;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;

@Schema(description="Ergo transaction")
public class ErgoTransaction {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="inputs")
    private List<ErgoTransactionInput> inputs = new ArrayList<ErgoTransactionInput>();
    @SerializedName(value="dataInputs")
    private List<ErgoTransactionDataInput> dataInputs = new ArrayList<ErgoTransactionDataInput>();
    @SerializedName(value="outputs")
    private List<ErgoTransactionOutput> outputs = new ArrayList<ErgoTransactionOutput>();
    @SerializedName(value="size")
    private Integer size = null;

    public ErgoTransaction id(String string) {
        this.id = string;
        return this;
    }

    @Schema(description="")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public ErgoTransaction inputs(List<ErgoTransactionInput> list) {
        this.inputs = list;
        return this;
    }

    public ErgoTransaction addInputsItem(ErgoTransactionInput ergoTransactionInput) {
        this.inputs.add(ergoTransactionInput);
        return this;
    }

    @Schema(required=true, description="Many transaction inputs")
    public List<ErgoTransactionInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<ErgoTransactionInput> list) {
        this.inputs = list;
    }

    public ErgoTransaction dataInputs(List<ErgoTransactionDataInput> list) {
        this.dataInputs = list;
        return this;
    }

    public ErgoTransaction addDataInputsItem(ErgoTransactionDataInput ergoTransactionDataInput) {
        this.dataInputs.add(ergoTransactionDataInput);
        return this;
    }

    @Schema(required=true, description="Many transaction data inputs")
    public List<ErgoTransactionDataInput> getDataInputs() {
        return this.dataInputs;
    }

    public void setDataInputs(List<ErgoTransactionDataInput> list) {
        this.dataInputs = list;
    }

    public ErgoTransaction outputs(List<ErgoTransactionOutput> list) {
        this.outputs = list;
        return this;
    }

    public ErgoTransaction addOutputsItem(ErgoTransactionOutput ergoTransactionOutput) {
        this.outputs.add(ergoTransactionOutput);
        return this;
    }

    @Schema(required=true, description="Many transaction outputs")
    public List<ErgoTransactionOutput> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ErgoTransactionOutput> list) {
        this.outputs = list;
    }

    public ErgoTransaction size(Integer n) {
        this.size = n;
        return this;
    }

    @Schema(description="Size in bytes")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer n) {
        this.size = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ErgoTransaction ergoTransaction = (ErgoTransaction)object;
        return Objects.equals(this.id, ergoTransaction.id) && Objects.equals(this.inputs, ergoTransaction.inputs) && Objects.equals(this.dataInputs, ergoTransaction.dataInputs) && Objects.equals(this.outputs, ergoTransaction.outputs) && Objects.equals(this.size, ergoTransaction.size);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.inputs, this.dataInputs, this.outputs, this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ErgoTransaction {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        stringBuilder.append("    dataInputs: ").append(this.toIndentedString(this.dataInputs)).append("\n");
        stringBuilder.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        stringBuilder.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

