/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.Asset;
import org.ergoplatform.explorer.client.model.Registers;

public class TransactionOutput {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="value")
    private BigDecimal value = null;
    @SerializedName(value="creationHeight")
    private Integer creationHeight = null;
    @SerializedName(value="ergoTree")
    private String ergoTree = null;
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="assets")
    private List<Asset> assets = new ArrayList<Asset>();
    @SerializedName(value="additionalRegisters")
    private Registers additionalRegisters = null;
    @SerializedName(value="spentTransactionId")
    private String spentTransactionId = null;
    @SerializedName(value="mainChain")
    private Boolean mainChain = null;

    public TransactionOutput id(String string) {
        this.id = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public TransactionOutput value(BigDecimal bigDecimal) {
        this.value = bigDecimal;
        return this;
    }

    @Schema(example="14.7", required=true, description="Amount of Ergo token")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public TransactionOutput creationHeight(Integer n) {
        this.creationHeight = n;
        return this;
    }

    @Schema(example="9149", required=true, description="Height the output was created at")
    public Integer getCreationHeight() {
        return this.creationHeight;
    }

    public void setCreationHeight(Integer n) {
        this.creationHeight = n;
    }

    public TransactionOutput ergoTree(String string) {
        this.ergoTree = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getErgoTree() {
        return this.ergoTree;
    }

    public void setErgoTree(String string) {
        this.ergoTree = string;
    }

    public TransactionOutput address(String string) {
        this.address = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public TransactionOutput assets(List<Asset> list) {
        this.assets = list;
        return this;
    }

    public TransactionOutput addAssetsItem(Asset asset) {
        this.assets.add(asset);
        return this;
    }

    @Schema(required=true, description="Assets list in the transaction")
    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(List<Asset> list) {
        this.assets = list;
    }

    public TransactionOutput additionalRegisters(Registers registers) {
        this.additionalRegisters = registers;
        return this;
    }

    @Schema(required=true, description="")
    public Registers getAdditionalRegisters() {
        return this.additionalRegisters;
    }

    public void setAdditionalRegisters(Registers registers) {
        this.additionalRegisters = registers;
    }

    public TransactionOutput spentTransactionId(String string) {
        this.spentTransactionId = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getSpentTransactionId() {
        return this.spentTransactionId;
    }

    public void setSpentTransactionId(String string) {
        this.spentTransactionId = string;
    }

    public TransactionOutput mainChain(Boolean bl) {
        this.mainChain = bl;
        return this;
    }

    @Schema(example="true", required=true, description="Flag indication wheather box belongs to main chain")
    public Boolean isMainChain() {
        return this.mainChain;
    }

    public void setMainChain(Boolean bl) {
        this.mainChain = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransactionOutput transactionOutput = (TransactionOutput)object;
        return Objects.equals(this.id, transactionOutput.id) && Objects.equals(this.value, transactionOutput.value) && Objects.equals(this.creationHeight, transactionOutput.creationHeight) && Objects.equals(this.ergoTree, transactionOutput.ergoTree) && Objects.equals(this.address, transactionOutput.address) && Objects.equals(this.assets, transactionOutput.assets) && Objects.equals(this.additionalRegisters, transactionOutput.additionalRegisters) && Objects.equals(this.spentTransactionId, transactionOutput.spentTransactionId) && Objects.equals(this.mainChain, transactionOutput.mainChain);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value, this.creationHeight, this.ergoTree, this.address, this.assets, this.additionalRegisters, this.spentTransactionId, this.mainChain);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class TransactionOutput {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        stringBuilder.append("    creationHeight: ").append(this.toIndentedString(this.creationHeight)).append("\n");
        stringBuilder.append("    ergoTree: ").append(this.toIndentedString(this.ergoTree)).append("\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        stringBuilder.append("    additionalRegisters: ").append(this.toIndentedString(this.additionalRegisters)).append("\n");
        stringBuilder.append("    spentTransactionId: ").append(this.toIndentedString(this.spentTransactionId)).append("\n");
        stringBuilder.append("    mainChain: ").append(this.toIndentedString(this.mainChain)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

