/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.SecretString;
import scala.Option;
import scala.util.Try;
import scorex.utils.Random;

public class Mnemonic {
    private final char[] _phrase;
    private final char[] _password;
    public static int DEFAULT_STRENGTH = 160;

    Mnemonic(char[] cArray, char[] cArray2) {
        this._phrase = cArray;
        this._password = cArray2;
    }

    public static byte[] getEntropy(int n) {
        return Random.randomBytes((int)(n / 8));
    }

    public static String generate(String string, int n, byte[] byArray) {
        org.ergoplatform.wallet.mnemonic.Mnemonic mnemonic = new org.ergoplatform.wallet.mnemonic.Mnemonic(string, n);
        Try try_ = mnemonic.toMnemonic(byArray);
        if (try_.isFailure()) {
            throw new RuntimeException(String.format("Cannot create mnemonic for languageId: %s, strength: %d", string, n));
        }
        return (String)try_.get();
    }

    public static String generateEnglishMnemonic() {
        byte[] byArray = Mnemonic.getEntropy(DEFAULT_STRENGTH);
        return Mnemonic.generate("english", DEFAULT_STRENGTH, byArray);
    }

    public static Mnemonic create(char[] cArray, char[] cArray2) {
        return new Mnemonic(cArray, cArray2);
    }

    public static Mnemonic create(SecretString secretString, SecretString secretString2) {
        return new Mnemonic(secretString.getData(), secretString2.getData());
    }

    public SecretString getPhrase() {
        return SecretString.create(this._phrase);
    }

    public SecretString getPassword() {
        return SecretString.create(this._password);
    }

    public byte[] toSeed() {
        Option<String> option = Iso.arrayCharToOptionString().to(this.getPassword());
        return org.ergoplatform.wallet.mnemonic.Mnemonic.toSeed((String)String.valueOf(this._phrase), option);
    }
}

