/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.TransactionInput;
import org.ergoplatform.explorer.client.model.TransactionOutput;

@Schema(description="Transaction without any lockers and unlockers")
public class Transaction {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="headerId")
    private String headerId = null;
    @SerializedName(value="timestamp")
    private Integer timestamp = null;
    @SerializedName(value="confirmationsCount")
    private Integer confirmationsCount = null;
    @SerializedName(value="inputs")
    private List<TransactionInput> inputs = new ArrayList<TransactionInput>();
    @SerializedName(value="outputs")
    private List<TransactionOutput> outputs = new ArrayList<TransactionOutput>();

    public Transaction id(String string) {
        this.id = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Transaction headerId(String string) {
        this.headerId = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getHeaderId() {
        return this.headerId;
    }

    public void setHeaderId(String string) {
        this.headerId = string;
    }

    public Transaction timestamp(Integer n) {
        this.timestamp = n;
        return this;
    }

    @Schema(required=true, description="")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer n) {
        this.timestamp = n;
    }

    public Transaction confirmationsCount(Integer n) {
        this.confirmationsCount = n;
        return this;
    }

    @Schema(example="142", description="Number of confimations in transaction")
    public Integer getConfirmationsCount() {
        return this.confirmationsCount;
    }

    public void setConfirmationsCount(Integer n) {
        this.confirmationsCount = n;
    }

    public Transaction inputs(List<TransactionInput> list) {
        this.inputs = list;
        return this;
    }

    public Transaction addInputsItem(TransactionInput transactionInput) {
        this.inputs.add(transactionInput);
        return this;
    }

    @Schema(required=true, description="Many transaction inputs")
    public List<TransactionInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<TransactionInput> list) {
        this.inputs = list;
    }

    public Transaction outputs(List<TransactionOutput> list) {
        this.outputs = list;
        return this;
    }

    public Transaction addOutputsItem(TransactionOutput transactionOutput) {
        this.outputs.add(transactionOutput);
        return this;
    }

    @Schema(required=true, description="Many transaction outputs")
    public List<TransactionOutput> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<TransactionOutput> list) {
        this.outputs = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)object;
        return Objects.equals(this.id, transaction.id) && Objects.equals(this.headerId, transaction.headerId) && Objects.equals(this.timestamp, transaction.timestamp) && Objects.equals(this.confirmationsCount, transaction.confirmationsCount) && Objects.equals(this.inputs, transaction.inputs) && Objects.equals(this.outputs, transaction.outputs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.headerId, this.timestamp, this.confirmationsCount, this.inputs, this.outputs);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class Transaction {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    headerId: ").append(this.toIndentedString(this.headerId)).append("\n");
        stringBuilder.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        stringBuilder.append("    confirmationsCount: ").append(this.toIndentedString(this.confirmationsCount)).append("\n");
        stringBuilder.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        stringBuilder.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

