/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.math.BigInteger;
import java.util.Objects;
import org.bouncycastle.math.ec.ECPoint;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.JavaHelpers;
import scala.Tuple2;
import scorex.util.encode.Base16$;
import sigmastate.AvlTreeData;
import sigmastate.SType;
import sigmastate.Values;
import sigmastate.serialization.ValueSerializer;
import sigmastate.serialization.ValueSerializer$;
import special.collection.Coll;
import special.sigma.AvlTree;
import special.sigma.BigInt;
import special.sigma.Box;
import special.sigma.GroupElement;
import special.sigma.SigmaProp;

public class ErgoValue<T> {
    private final T _value;
    private final ErgoType<T> _type;

    ErgoValue(T t, ErgoType<T> ergoType) {
        this._value = t;
        this._type = ergoType;
    }

    public T getValue() {
        return this._value;
    }

    public ErgoType<T> getType() {
        return this._type;
    }

    public String toHex() {
        Values.EvaluatedValue<SType> evaluatedValue = Iso.isoErgoValueToSValue().to(this);
        byte[] byArray = ValueSerializer$.MODULE$.serialize(evaluatedValue);
        return Base16$.MODULE$.encode(byArray);
    }

    public int hashCode() {
        return Objects.hash(this._type, this._value);
    }

    public boolean equals(Object object) {
        if (object instanceof ErgoValue) {
            ErgoValue ergoValue = (ErgoValue)object;
            return Objects.equals(this._type, ergoValue._type) && Objects.equals(this._value, ergoValue._value);
        }
        return false;
    }

    public static ErgoValue<Byte> of(byte by) {
        return new ErgoValue<Byte>((Byte)Iso.jbyteToByte().to(by), ErgoType.byteType());
    }

    public static ErgoValue<Short> of(short s) {
        return new ErgoValue<Short>((Short)Iso.jshortToShort().to(s), ErgoType.shortType());
    }

    public static ErgoValue<Integer> of(int n) {
        return new ErgoValue<Integer>((Integer)Iso.jintToInt().to(n), ErgoType.integerType());
    }

    public static ErgoValue<Long> of(long l) {
        return new ErgoValue<Long>((Long)Iso.jlongToLong().to(l), ErgoType.longType());
    }

    public static ErgoValue<Boolean> of(boolean bl) {
        return new ErgoValue<Boolean>((Boolean)Iso.jboolToBool().to(bl), ErgoType.booleanType());
    }

    public static ErgoValue<?> unit() {
        return JavaHelpers.UnitErgoVal();
    }

    public static ErgoValue<BigInt> of(BigInteger bigInteger) {
        return new ErgoValue<BigInt>(JavaHelpers.SigmaDsl().BigInt(bigInteger), ErgoType.bigIntType());
    }

    public static ErgoValue<GroupElement> of(ECPoint eCPoint) {
        return new ErgoValue<GroupElement>(JavaHelpers.SigmaDsl().GroupElement(eCPoint), ErgoType.groupElementType());
    }

    public static ErgoValue<GroupElement> of(GroupElement groupElement) {
        return new ErgoValue<GroupElement>(groupElement, ErgoType.groupElementType());
    }

    public static ErgoValue<SigmaProp> of(Values.SigmaBoolean sigmaBoolean) {
        return new ErgoValue<SigmaProp>(JavaHelpers.SigmaDsl().SigmaProp(sigmaBoolean), ErgoType.sigmaPropType());
    }

    public static ErgoValue<AvlTree> of(AvlTreeData avlTreeData) {
        return new ErgoValue<AvlTree>(JavaHelpers.SigmaDsl().avlTree(avlTreeData), ErgoType.avlTreeType());
    }

    public static ErgoValue<Box> of(ErgoBox ergoBox) {
        return new ErgoValue<Box>(JavaHelpers.SigmaDsl().Box(ergoBox), ErgoType.boxType());
    }

    public static ErgoValue<Coll<Byte>> of(byte[] byArray) {
        Coll<Object> coll = JavaHelpers.collFrom(byArray);
        ErgoType<Coll<Byte>> ergoType = ErgoType.collType(ErgoType.byteType());
        return new ErgoValue<Coll<Byte>>(coll, ergoType);
    }

    public static <A, B> ErgoValue<Tuple2<A, B>> pairOf(ErgoValue<A> ergoValue, ErgoValue<B> ergoValue2) {
        return new ErgoValue<Tuple2<A, B>>(new Tuple2(ergoValue.getValue(), ergoValue2.getValue()), ErgoType.pairType(ergoValue.getType(), ergoValue2.getType()));
    }

    public static <T> ErgoValue<Coll<T>> of(T[] TArray, ErgoType<T> ergoType) {
        Coll coll = JavaHelpers.SigmaDsl().Colls().fromArray(TArray, ergoType.getRType());
        return new ErgoValue<Coll<T>>(coll, ErgoType.collType(ergoType));
    }

    public static <T> ErgoValue<Coll<T>> of(Coll<T> coll, ErgoType<T> ergoType) {
        return new ErgoValue<Coll<T>>(coll, ErgoType.collType(ergoType));
    }

    public static ErgoValue<?> fromHex(String string) {
        byte[] byArray = JavaHelpers.decodeStringToBytes(string);
        Values.EvaluatedValue evaluatedValue = (Values.EvaluatedValue)ValueSerializer.deserialize((byte[])byArray, (int)0);
        ErgoValue<?> ergoValue = Iso.isoErgoValueToSValue().from((Values.EvaluatedValue<SType>)evaluatedValue);
        return ergoValue;
    }
}

