/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client;

import java.net.Proxy;
import java.text.DateFormat;
import java.time.format.DateTimeFormatter;
import okhttp3.OkHttpClient;
import org.ergoplatform.explorer.client.GsonCustomConverterFactory;
import org.ergoplatform.explorer.client.JSON;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ExplorerApiClient {
    private String _hostUrl;
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private JSON json;
    private Proxy proxy;

    public ExplorerApiClient(String string) {
        this(string, null);
    }

    public ExplorerApiClient(String string, Proxy proxy) {
        this._hostUrl = string;
        this.proxy = proxy;
        this.createDefaultAdapter();
    }

    public void createDefaultAdapter() {
        this.json = new JSON();
        this.okBuilder = new OkHttpClient.Builder();
        if (this.proxy != null) {
            this.okBuilder.proxy(this.proxy);
        }
        if (!this._hostUrl.endsWith("/")) {
            this._hostUrl = this._hostUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(this._hostUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public <S> S createService(Class<S> clazz) {
        return (S)this.adapterBuilder.client(this.okBuilder.build()).build().create(clazz);
    }

    public ExplorerApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ExplorerApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ExplorerApiClient setOffsetDateTimeFormat(DateTimeFormatter dateTimeFormatter) {
        this.json.setOffsetDateTimeFormat(dateTimeFormatter);
        return this;
    }

    public ExplorerApiClient setLocalDateFormat(DateTimeFormatter dateTimeFormatter) {
        this.json.setLocalDateFormat(dateTimeFormatter);
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ExplorerApiClient setAdapterBuilder(Retrofit.Builder builder) {
        this.adapterBuilder = builder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return this.okBuilder;
    }

    public void configureFromOkclient(OkHttpClient okHttpClient) {
        this.okBuilder = okHttpClient.newBuilder();
    }

    public void configureFromOkClientBuilder(OkHttpClient.Builder builder) {
        this.okBuilder = builder;
    }
}

