/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.TransactionHintsBag;
import org.ergoplatform.restapi.client.TransactionSigningRequestSecrets;
import org.ergoplatform.restapi.client.UnsignedErgoTransaction;

@Schema(description="A request to sign a transaction with secrets provided")
public class TransactionSigningRequest {
    @SerializedName(value="tx")
    private UnsignedErgoTransaction tx = null;
    @SerializedName(value="inputsRaw")
    private List<String> inputsRaw = null;
    @SerializedName(value="dataInputsRaw")
    private List<String> dataInputsRaw = null;
    @SerializedName(value="hints")
    private TransactionHintsBag hints = null;
    @SerializedName(value="secrets")
    private TransactionSigningRequestSecrets secrets = null;

    public TransactionSigningRequest tx(UnsignedErgoTransaction unsignedErgoTransaction) {
        this.tx = unsignedErgoTransaction;
        return this;
    }

    @Schema(required=true, description="")
    public UnsignedErgoTransaction getTx() {
        return this.tx;
    }

    public void setTx(UnsignedErgoTransaction unsignedErgoTransaction) {
        this.tx = unsignedErgoTransaction;
    }

    public TransactionSigningRequest inputsRaw(List<String> list) {
        this.inputsRaw = list;
        return this;
    }

    public TransactionSigningRequest addInputsRawItem(String string) {
        if (this.inputsRaw == null) {
            this.inputsRaw = new ArrayList<String>();
        }
        this.inputsRaw.add(string);
        return this;
    }

    @Schema(description="Optional list of inputs to be used in serialized form")
    public List<String> getInputsRaw() {
        return this.inputsRaw;
    }

    public void setInputsRaw(List<String> list) {
        this.inputsRaw = list;
    }

    public TransactionSigningRequest dataInputsRaw(List<String> list) {
        this.dataInputsRaw = list;
        return this;
    }

    public TransactionSigningRequest addDataInputsRawItem(String string) {
        if (this.dataInputsRaw == null) {
            this.dataInputsRaw = new ArrayList<String>();
        }
        this.dataInputsRaw.add(string);
        return this;
    }

    @Schema(description="Optional list of inputs to be used in serialized form")
    public List<String> getDataInputsRaw() {
        return this.dataInputsRaw;
    }

    public void setDataInputsRaw(List<String> list) {
        this.dataInputsRaw = list;
    }

    public TransactionSigningRequest hints(TransactionHintsBag transactionHintsBag) {
        this.hints = transactionHintsBag;
        return this;
    }

    @Schema(description="")
    public TransactionHintsBag getHints() {
        return this.hints;
    }

    public void setHints(TransactionHintsBag transactionHintsBag) {
        this.hints = transactionHintsBag;
    }

    public TransactionSigningRequest secrets(TransactionSigningRequestSecrets transactionSigningRequestSecrets) {
        this.secrets = transactionSigningRequestSecrets;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionSigningRequestSecrets getSecrets() {
        return this.secrets;
    }

    public void setSecrets(TransactionSigningRequestSecrets transactionSigningRequestSecrets) {
        this.secrets = transactionSigningRequestSecrets;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransactionSigningRequest transactionSigningRequest = (TransactionSigningRequest)object;
        return Objects.equals(this.tx, transactionSigningRequest.tx) && Objects.equals(this.inputsRaw, transactionSigningRequest.inputsRaw) && Objects.equals(this.dataInputsRaw, transactionSigningRequest.dataInputsRaw) && Objects.equals(this.hints, transactionSigningRequest.hints) && Objects.equals(this.secrets, transactionSigningRequest.secrets);
    }

    public int hashCode() {
        return Objects.hash(this.tx, this.inputsRaw, this.dataInputsRaw, this.hints, this.secrets);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class TransactionSigningRequest {\n");
        stringBuilder.append("    tx: ").append(this.toIndentedString(this.tx)).append("\n");
        stringBuilder.append("    inputsRaw: ").append(this.toIndentedString(this.inputsRaw)).append("\n");
        stringBuilder.append("    dataInputsRaw: ").append(this.toIndentedString(this.dataInputsRaw)).append("\n");
        stringBuilder.append("    hints: ").append(this.toIndentedString(this.hints)).append("\n");
        stringBuilder.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

