/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 0.1
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Request for generation of asset issue transaction
 */
@Schema(description = "Request for generation of asset issue transaction")
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2019-10-19T14:53:04.559Z[GMT]")
public class AssetIssueRequest {
  @SerializedName("address")
  private String address = null;

  @SerializedName("amount")
  private Long amount = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("decimals")
  private Integer decimals = null;

  @SerializedName("fee")
  private Long fee = null;

  @SerializedName("registers")
  private Registers registers = null;

  public AssetIssueRequest address(String address) {
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @Schema(description = "")
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public AssetIssueRequest amount(Long amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Supply amount
   * @return amount
  **/
  @Schema(example = "1000000", required = true, description = "Supply amount")
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public AssetIssueRequest name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Assets name
   * @return name
  **/
  @Schema(example = "TST", required = true, description = "Assets name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AssetIssueRequest description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Assets description
   * @return description
  **/
  @Schema(example = "Test token", required = true, description = "Assets description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AssetIssueRequest decimals(Integer decimals) {
    this.decimals = decimals;
    return this;
  }

   /**
   * Number of decimal places
   * @return decimals
  **/
  @Schema(example = "8", required = true, description = "Number of decimal places")
  public Integer getDecimals() {
    return decimals;
  }

  public void setDecimals(Integer decimals) {
    this.decimals = decimals;
  }

  public AssetIssueRequest fee(Long fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Optional, default transaction fee from settings will be used if not defined
   * @return fee
  **/
  @Schema(example = "1000000", description = "Optional, default transaction fee from settings will be used if not defined")
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public AssetIssueRequest registers(Registers registers) {
    this.registers = registers;
    return this;
  }

   /**
   * Get registers
   * @return registers
  **/
  @Schema(description = "")
  public Registers getRegisters() {
    return registers;
  }

  public void setRegisters(Registers registers) {
    this.registers = registers;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AssetIssueRequest assetIssueRequest = (AssetIssueRequest) o;
    return Objects.equals(this.address, assetIssueRequest.address) &&
        Objects.equals(this.amount, assetIssueRequest.amount) &&
        Objects.equals(this.name, assetIssueRequest.name) &&
        Objects.equals(this.description, assetIssueRequest.description) &&
        Objects.equals(this.decimals, assetIssueRequest.decimals) &&
        Objects.equals(this.fee, assetIssueRequest.fee) &&
        Objects.equals(this.registers, assetIssueRequest.registers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, amount, name, description, decimals, fee, registers);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AssetIssueRequest {\n");
    
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    decimals: ").append(toIndentedString(decimals)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    registers: ").append(toIndentedString(registers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
