/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Fork info")
public class ForksInfoForks {
    @SerializedName(value="length")
    private Integer length = null;
    @SerializedName(value="branchPointHeight")
    private Integer branchPointHeight = null;
    @SerializedName(value="orphaned")
    private Boolean orphaned = null;
    @SerializedName(value="members")
    private List<List<Object>> members = null;

    public ForksInfoForks length(Integer n) {
        this.length = n;
        return this;
    }

    @Schema(example="109", description="Total number of forks")
    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer n) {
        this.length = n;
    }

    public ForksInfoForks branchPointHeight(Integer n) {
        this.branchPointHeight = n;
        return this;
    }

    @Schema(example="558", description="Height chain forked from")
    public Integer getBranchPointHeight() {
        return this.branchPointHeight;
    }

    public void setBranchPointHeight(Integer n) {
        this.branchPointHeight = n;
    }

    public ForksInfoForks orphaned(Boolean bl) {
        this.orphaned = bl;
        return this;
    }

    @Schema(description="True if fork is not linked to main chain, False otherwise")
    public Boolean isOrphaned() {
        return this.orphaned;
    }

    public void setOrphaned(Boolean bl) {
        this.orphaned = bl;
    }

    public ForksInfoForks members(List<List<Object>> list) {
        this.members = list;
        return this;
    }

    public ForksInfoForks addMembersItem(List<Object> list) {
        if (this.members == null) {
            this.members = new ArrayList<List<Object>>();
        }
        this.members.add(list);
        return this;
    }

    @Schema(description="")
    public List<List<Object>> getMembers() {
        return this.members;
    }

    public void setMembers(List<List<Object>> list) {
        this.members = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ForksInfoForks forksInfoForks = (ForksInfoForks)object;
        return Objects.equals(this.length, forksInfoForks.length) && Objects.equals(this.branchPointHeight, forksInfoForks.branchPointHeight) && Objects.equals(this.orphaned, forksInfoForks.orphaned) && Objects.equals(this.members, forksInfoForks.members);
    }

    public int hashCode() {
        return Objects.hash(this.length, this.branchPointHeight, this.orphaned, this.members);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ForksInfoForks {\n");
        stringBuilder.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        stringBuilder.append("    branchPointHeight: ").append(this.toIndentedString(this.branchPointHeight)).append("\n");
        stringBuilder.append("    orphaned: ").append(this.toIndentedString(this.orphaned)).append("\n");
        stringBuilder.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

