/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigInteger;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.Miner;

@Schema(description="Block for search results")
public class SearchBlock {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="timestamp")
    private Long timestamp = null;
    @SerializedName(value="transactionsCount")
    private Integer transactionsCount = null;
    @SerializedName(value="miner")
    private Miner miner = null;
    @SerializedName(value="minerReward")
    private Long minerReward = null;
    @SerializedName(value="difficulty")
    private BigInteger difficulty = null;
    @SerializedName(value="size")
    private Integer size = null;

    public SearchBlock id(String string) {
        this.id = string;
        return this;
    }

    @Schema(description="")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public SearchBlock height(Integer n) {
        this.height = n;
        return this;
    }

    @Schema(example="667", required=true, description="")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer n) {
        this.height = n;
    }

    public SearchBlock timestamp(Long l) {
        this.timestamp = l;
        return this;
    }

    @Schema(required=true, description="")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long l) {
        this.timestamp = l;
    }

    public SearchBlock transactionsCount(Integer n) {
        this.transactionsCount = n;
        return this;
    }

    @Schema(example="667", required=true, description="")
    public Integer getTransactionsCount() {
        return this.transactionsCount;
    }

    public void setTransactionsCount(Integer n) {
        this.transactionsCount = n;
    }

    public SearchBlock miner(Miner miner) {
        this.miner = miner;
        return this;
    }

    @Schema(required=true, description="")
    public Miner getMiner() {
        return this.miner;
    }

    public void setMiner(Miner miner) {
        this.miner = miner;
    }

    public SearchBlock minerReward(Long l) {
        this.minerReward = l;
        return this;
    }

    @Schema(example="12045", required=true, description="Miner Reward")
    public Long getMinerReward() {
        return this.minerReward;
    }

    public void setMinerReward(Long l) {
        this.minerReward = l;
    }

    public SearchBlock difficulty(BigInteger bigInteger) {
        this.difficulty = bigInteger;
        return this;
    }

    @Schema(example="123", description="")
    public BigInteger getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(BigInteger bigInteger) {
        this.difficulty = bigInteger;
    }

    public SearchBlock size(Integer n) {
        this.size = n;
        return this;
    }

    @Schema(example="1030453", required=true, description="Size of block in bytes")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer n) {
        this.size = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SearchBlock searchBlock = (SearchBlock)object;
        return Objects.equals(this.id, searchBlock.id) && Objects.equals(this.height, searchBlock.height) && Objects.equals(this.timestamp, searchBlock.timestamp) && Objects.equals(this.transactionsCount, searchBlock.transactionsCount) && Objects.equals(this.miner, searchBlock.miner) && Objects.equals(this.minerReward, searchBlock.minerReward) && Objects.equals(this.difficulty, searchBlock.difficulty) && Objects.equals(this.size, searchBlock.size);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.height, this.timestamp, this.transactionsCount, this.miner, this.minerReward, this.difficulty, this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class SearchBlock {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        stringBuilder.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        stringBuilder.append("    transactionsCount: ").append(this.toIndentedString(this.transactionsCount)).append("\n");
        stringBuilder.append("    miner: ").append(this.toIndentedString(this.miner)).append("\n");
        stringBuilder.append("    minerReward: ").append(this.toIndentedString(this.minerReward)).append("\n");
        stringBuilder.append("    difficulty: ").append(this.toIndentedString(this.difficulty)).append("\n");
        stringBuilder.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

