/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.Objects;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.PreHeader;
import scala.Byte;
import scala.Int;
import scala.Long;
import scala.Option;
import scala.Short;
import scala.Tuple2;
import scalan.RType;
import special.collection.Coll;
import special.sigma.AvlTree;
import special.sigma.BigInt;
import special.sigma.GroupElement;
import special.sigma.Header;
import special.sigma.SigmaProp;

public class ErgoType<T> {
    private static ErgoType<Byte> _byte = new ErgoType(RType.ByteType());
    private static ErgoType<Short> _short = new ErgoType(RType.ShortType());
    private static ErgoType<Int> _integer = new ErgoType(RType.IntType());
    private static ErgoType<Long> _long = new ErgoType(RType.LongType());
    private static ErgoType<BigInt> _bigInt = new ErgoType<BigInt>(JavaHelpers.BigIntRType());
    private static ErgoType<GroupElement> _groupElement = new ErgoType<GroupElement>(JavaHelpers.GroupElementRType());
    private static ErgoType<SigmaProp> _sigmaProp = new ErgoType<SigmaProp>(JavaHelpers.SigmaPropRType());
    private static ErgoType<AvlTree> _avlTree = new ErgoType<AvlTree>(JavaHelpers.AvlTreeRType());
    private static ErgoType<Header> _header = new ErgoType<Header>(JavaHelpers.HeaderRType());
    private static ErgoType<PreHeader> _preHeader = new ErgoType<special.sigma.PreHeader>(JavaHelpers.PreHeaderRType());
    private final RType<T> _rtype;

    public RType<T> getRType() {
        return this._rtype;
    }

    ErgoType(RType<T> rType) {
        this._rtype = rType;
    }

    public int hashCode() {
        return Objects.hashCode(this._rtype);
    }

    public boolean equals(Object object) {
        return object instanceof ErgoType && Objects.equals(this._rtype, ((ErgoType)object)._rtype);
    }

    public static ErgoType<Byte> byteType() {
        return _byte;
    }

    public static ErgoType<Short> shortType() {
        return _short;
    }

    public static ErgoType<Int> integerType() {
        return _integer;
    }

    public static ErgoType<Long> longType() {
        return _long;
    }

    public static ErgoType<BigInt> bigIntType() {
        return _bigInt;
    }

    public static ErgoType<GroupElement> groupElementType() {
        return _groupElement;
    }

    public static ErgoType<SigmaProp> sigmaPropType() {
        return _sigmaProp;
    }

    public static ErgoType<AvlTree> avlTreeType() {
        return _avlTree;
    }

    public static ErgoType<Header> headerType() {
        return _header;
    }

    public static ErgoType<PreHeader> preHeaderType() {
        return _preHeader;
    }

    public static <A, B> ErgoType<Tuple2<A, B>> pairType(ErgoType<A> ergoType, ErgoType<B> ergoType2) {
        return new ErgoType<Tuple2<A, B>>(RType.pairRType(ergoType._rtype, ergoType2._rtype));
    }

    public static <A> ErgoType<Coll<A>> collType(ErgoType<A> ergoType) {
        return new ErgoType<Coll<A>>(JavaHelpers.collRType(ergoType._rtype));
    }

    public static <A> ErgoType<Option<A>> optionType(ErgoType<A> ergoType) {
        return new ErgoType<Option<A>>(RType.optionRType(ergoType._rtype));
    }
}

