/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.gson.Gson;
import java.util.List;
import java.util.stream.Collectors;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.Input;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.SignedInput;
import org.ergoplatform.appkit.SignedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.appkit.impl.SignedInputImpl;
import org.ergoplatform.restapi.client.ErgoTransaction;
import org.ergoplatform.restapi.client.JSON;
import sigmastate.Values;

public class SignedTransactionImpl
implements SignedTransaction {
    private final BlockchainContextImpl _ctx;
    private final ErgoLikeTransaction _tx;
    private final int _txCost;

    public SignedTransactionImpl(BlockchainContextImpl blockchainContextImpl, ErgoLikeTransaction ergoLikeTransaction, int n) {
        this._ctx = blockchainContextImpl;
        this._tx = ergoLikeTransaction;
        this._txCost = n;
    }

    public ErgoLikeTransaction getTx() {
        return this._tx;
    }

    public String toString() {
        return "Signed(" + this._tx + ")";
    }

    @Override
    public String getId() {
        return this._tx.id();
    }

    @Override
    public String toJson(boolean bl) {
        return this.toJson(bl, true);
    }

    @Override
    public String toJson(boolean bl, boolean bl2) {
        ErgoTransaction ergoTransaction = ScalaBridge.isoErgoTransaction().from(this._tx);
        if (bl) {
            ergoTransaction.getOutputs().forEach(ergoTransactionOutput -> {
                Values.ErgoTree ergoTree = ScalaBridge.isoStringToErgoTree().to(ergoTransactionOutput.getErgoTree());
                ergoTransactionOutput.ergoTree(ergoTree.toString());
            });
        }
        Gson gson = bl || bl2 ? JSON.createGson().setPrettyPrinting().create() : this._ctx.getApiClient().getGson();
        String string = gson.toJson((Object)ergoTransaction);
        return string;
    }

    @Override
    public List<SignedInput> getSignedInputs() {
        List list = Iso.JListToIndexedSeq(Iso.identityIso()).from(this._tx.inputs());
        List<SignedInput> list2 = list.stream().map(input -> new SignedInputImpl(this, (Input)input)).collect(Collectors.toList());
        return list2;
    }

    @Override
    public List<InputBox> getOutputsToSpend() {
        List list = Iso.JListToIndexedSeq(Iso.identityIso()).from(this._tx.outputs());
        List<InputBox> list2 = list.stream().map(ergoBox -> new InputBoxImpl(this._ctx, (ErgoBox)ergoBox)).collect(Collectors.toList());
        return list2;
    }

    @Override
    public int getCost() {
        return this._txCost;
    }
}

