/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.Asset;
import org.ergoplatform.restapi.client.Registers;

@Schema(description="Request for generation of payment transaction to a given address")
public class PaymentRequest {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="value")
    private Long value = null;
    @SerializedName(value="assets")
    private List<Asset> assets = null;
    @SerializedName(value="registers")
    private Registers registers = null;

    public PaymentRequest address(String string) {
        this.address = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public PaymentRequest value(Long l) {
        this.value = l;
        return this;
    }

    @Schema(example="1", required=true, description="Payment amount")
    public Long getValue() {
        return this.value;
    }

    public void setValue(Long l) {
        this.value = l;
    }

    public PaymentRequest assets(List<Asset> list) {
        this.assets = list;
        return this;
    }

    public PaymentRequest addAssetsItem(Asset asset) {
        if (this.assets == null) {
            this.assets = new ArrayList<Asset>();
        }
        this.assets.add(asset);
        return this;
    }

    @Schema(description="Assets list in the transaction")
    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(List<Asset> list) {
        this.assets = list;
    }

    public PaymentRequest registers(Registers registers) {
        this.registers = registers;
        return this;
    }

    @Schema(description="")
    public Registers getRegisters() {
        return this.registers;
    }

    public void setRegisters(Registers registers) {
        this.registers = registers;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PaymentRequest paymentRequest = (PaymentRequest)object;
        return Objects.equals(this.address, paymentRequest.address) && Objects.equals(this.value, paymentRequest.value) && Objects.equals(this.assets, paymentRequest.assets) && Objects.equals(this.registers, paymentRequest.registers);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.value, this.assets, this.registers);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class PaymentRequest {\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        stringBuilder.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        stringBuilder.append("    registers: ").append(this.toIndentedString(this.registers)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

