/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.math.BigInteger;
import java.util.Objects;
import org.bouncycastle.math.ec.ECPoint;
import org.ergoplatform.appkit.ErgoValue;
import sigmastate.AvlTreeData;
import sigmastate.Values;
import special.sigma.GroupElement;

public class ContextVar {
    public static final byte MIN_ID = 0;
    public static final byte MAX_ID = 127;
    private final byte _id;
    private final ErgoValue<?> _value;

    public ContextVar(byte by, ErgoValue<?> ergoValue) {
        if (by < 0) {
            throw new IllegalArgumentException(String.format("Context variable id should be in range [0 .. $d]: %d", (byte)127, by));
        }
        this._id = by;
        this._value = ergoValue;
    }

    public byte getId() {
        return this._id;
    }

    public ErgoValue<?> getValue() {
        return this._value;
    }

    public int hashCode() {
        return this._value.hashCode() + this._id;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ContextVar) {
            ContextVar contextVar = (ContextVar)object;
            return this._id == contextVar._id && Objects.equals(this._value, contextVar._value);
        }
        return false;
    }

    public static ContextVar of(byte by, byte by2) {
        return new ContextVar(by, ErgoValue.of(by2));
    }

    public static ContextVar of(byte by, short s) {
        return new ContextVar(by, ErgoValue.of(s));
    }

    public static ContextVar of(byte by, int n) {
        return new ContextVar(by, ErgoValue.of(n));
    }

    public static ContextVar of(byte by, long l) {
        return new ContextVar(by, ErgoValue.of(l));
    }

    public static ContextVar of(byte by, BigInteger bigInteger) {
        return new ContextVar(by, ErgoValue.of(bigInteger));
    }

    public static ContextVar of(byte by, ECPoint eCPoint) {
        return new ContextVar(by, ErgoValue.of(eCPoint));
    }

    public static ContextVar of(byte by, GroupElement groupElement) {
        return new ContextVar(by, ErgoValue.of(groupElement));
    }

    public static ContextVar of(byte by, Values.SigmaBoolean sigmaBoolean) {
        return new ContextVar(by, ErgoValue.of(sigmaBoolean));
    }

    public static ContextVar of(byte by, AvlTreeData avlTreeData) {
        return new ContextVar(by, ErgoValue.of(avlTreeData));
    }

    public static ContextVar of(byte by, byte[] byArray) {
        return new ContextVar(by, ErgoValue.of(byArray));
    }

    public static <T> ContextVar of(byte by, ErgoValue<T> ergoValue) {
        return new ContextVar(by, ergoValue);
    }
}

