/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import com.google.gson.Gson;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.appkit.ContextVar;
import org.ergoplatform.appkit.ErgoId;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.JavaHelpers;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.ScalaBridge;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.JSON;
import scala.Tuple2;
import sigmastate.Values;
import sigmastate.interpreter.ContextExtension;
import special.collection.Coll;

public class InputBoxImpl
implements InputBox {
    private final BlockchainContextImpl _ctx;
    private final ErgoId _id;
    private final ErgoBox _ergoBox;
    private final ErgoTransactionOutput _boxData;
    private ContextExtension _extension;

    public InputBoxImpl(BlockchainContextImpl blockchainContextImpl, ErgoTransactionOutput ergoTransactionOutput) {
        this._ctx = blockchainContextImpl;
        this._id = new ErgoId(JavaHelpers.decodeStringToBytes(ergoTransactionOutput.getBoxId()));
        this._ergoBox = ScalaBridge.isoErgoTransactionOutput().to(ergoTransactionOutput);
        this._boxData = ergoTransactionOutput;
        this._extension = ContextExtension.empty();
    }

    public InputBoxImpl(BlockchainContextImpl blockchainContextImpl, ErgoBox ergoBox) {
        this._ctx = blockchainContextImpl;
        this._ergoBox = ergoBox;
        this._id = new ErgoId(ergoBox.id());
        this._boxData = ScalaBridge.isoErgoTransactionOutput().from(ergoBox);
        this._extension = ContextExtension.empty();
    }

    @Override
    public ErgoId getId() {
        return this._id;
    }

    @Override
    public Long getValue() {
        return this._ergoBox.value();
    }

    @Override
    public List<ErgoToken> getTokens() {
        List<ErgoToken> list = Iso.isoTokensListToPairsColl().from((Coll<Tuple2<byte[], Object>>)this._ergoBox.additionalTokens());
        return list;
    }

    @Override
    public List<ErgoValue<?>> getRegisters() {
        return JavaHelpers.getBoxRegisters(this._ergoBox);
    }

    @Override
    public Values.ErgoTree getErgoTree() {
        return this._ergoBox.ergoTree();
    }

    @Override
    public InputBox withContextVars(ContextVar ... contextVarArray) {
        ContextExtension contextExtension = Iso.isoContextVarsToContextExtension().to(Stream.of(contextVarArray).collect(Collectors.toList()));
        InputBoxImpl inputBoxImpl = new InputBoxImpl(this._ctx, this._ergoBox);
        inputBoxImpl._extension = contextExtension;
        return inputBoxImpl;
    }

    @Override
    public String toJson(boolean bl) {
        return this.toJson(bl, true);
    }

    @Override
    public String toJson(boolean bl, boolean bl2) {
        Gson gson = bl || bl2 ? JSON.createGson().setPrettyPrinting().create() : this._ctx.getApiClient().getGson();
        ErgoTransactionOutput ergoTransactionOutput = this._boxData;
        if (bl) {
            ergoTransactionOutput = this._ctx.getApiClient().cloneDataObject(this._boxData);
            ergoTransactionOutput.ergoTree(this._ergoBox.ergoTree().toString());
        }
        String string = gson.toJson((Object)ergoTransactionOutput);
        return string;
    }

    public ErgoBox getErgoBox() {
        return this._ergoBox;
    }

    public ContextExtension getExtension() {
        return this._extension;
    }

    public String toString() {
        return String.format("InputBox(%s, %s)", this.getId(), this.getValue());
    }
}

